#   MailScanner - SMTP E-Mail Virus Scanner
#   Copyright (C) 2001  Julian Field
#
#   $Id: workarea.pl,v 1.3 2002/02/28 14:08:04 jkf Exp $
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#   The author, Julian Field, can be contacted by email at
#      Jules@JulianField.net
#   or by paper mail at
#      Julian Field
#      Dept of Electronics & Computer Science
#      University of Southampton
#      Southampton
#      SO17 1BJ
#      United Kingdom
#

# Build the tree of incoming messages, including the headers file for each one.
# The dirs go into the var/incoming dir, with the header files in there too.

my($rm) = '/bin/rm';

sub BuildInDirs {
  my($IncomingDir, $MessageIds) = @_;
  my($id);

  chdir $IncomingDir or Log::DieLog("Cannot chdir to $IncomingDir, %s", $!);
  foreach $id (@$MessageIds) {
    mkdir $id, 0700 or Log::DieLog("Cannot mkdir $IncomingDir / $id, %s", $!);
  }
  Log::DebugLog('Going to scan ' . scalar(@$MessageIds) . ' messages');
}

# Clean up the whole of my work area
sub ClearWorkArea {
  my($Dir) = @_;
  my($f);
  local(*WORKDIR);

  #Log::InfoLog("Clearing temporary work area.");

  chdir $Dir or Log::DieLog("Cannot chdir to work area $Dir, %s", $!);

  # Clean up the whole thing
  opendir(WORKDIR, ".") or Log::DieLog("Cannot read work area $Dir, %s", $!);
  while($f = readdir WORKDIR) {
    next if $f =~ /^\./;
    # Needs untaint:
    $f =~ /([-\w]+\.header)$/ and unlink $1;
    # Also needs untaint... sledgehammer. nut.
    $f =~ /(.*)/;
    system("$rm -rf $1") if -d $1;
  }
  closedir WORKDIR;
}

# Clean up the supplied list of messages from the work area
sub ClearWorkAreaIds {
  my($Dir, $IdList) = @_;
  my($f);
  local(*WORKDIR);

  #Log::InfoLog("Partially clearing temporary work area.");

  chdir $Dir or Log::DieLog("Cannot chdir to work area $Dir, %m");

  # Clean up IDs in list
  opendir(WORKDIR, ".") or Log::DieLog("Cannot read work area $Dir, %m");
  while($f = readdir WORKDIR) {
    next if $f =~ /^\./;
    next unless grep(/^$f$/, @$IdList); # Skip those not in the list
    # Needs untaint:
    $f =~ /([-\w]+\.header)$/ and unlink $1;
    # Also needs untaint... sledgehammer. nut.
    $f =~ /(.*)/;
    system("$rm -rf $1") if -d $1;
  }
  closedir WORKDIR;
}

1;
