/*
                              Manual Page Viewer

	Displays parsed groff output for finished apperance of manual
	pages.

 */

#ifndef VIEWER_H
#define VIEWER_H

#include <sys/types.h>
#include <gtk/gtk.h>


/*
 *	Viewer index ctree index item structure:
 */
typedef struct {

#define ViewerIndexItemTypeDirectory	0
#define ViewerIndexItemTypeManualPage	1
#define ViewerIndexItemTypeOtherFile	2

	gint type;	/* One of ViewerIndexItemType*. */

	gchar *file_name_full;

} viewer_index_item_struct;

/*
 *	Viewer structure:
 */
typedef struct {

	gbool initialized;
	gbool map_state;
	gbool processing;
	gint stop_count;

	gpointer core_ptr;	/* Pointer back to core. */
	gint editor_num;	/* Editor number on core struct that called
				 * this viewer, can be -1 for none.
				 */

	GtkWidget *toplevel;
	GtkWidget *main_vbox;

        GtkWidget *menu_bar_dock, *menu_bar;
        GtkWidget *tool_bar_dock, *tool_bar;

	GtkWidget *main_notebook;

	/* Currently selected page on main_notebook, can be one of
	 * ViewerPageNum*.
	 */
#define ViewerPageNumView	0
#define ViewerPageNumIndex	1
#define ViewerPageNumSearch	2
	gint current_page;

	/* GtkText widget which displays current manual page contents. */
	GtkWidget *view_text;

	/* Index listing of available manual pages, each branch has
	 * an item data of type viewer_index_item_struct.
	 * There are 4 columns; name, lines, read, short description
	 */
	GtkWidget *index_ctree;

	/* Selected branch on index_ctree, can be NULL. */
	GtkCTreeNode *selected_index_branch;

	/* Buttons on index ctree page. */
	GtkWidget	*index_parent_btn,
			*index_goto_btn,
			*index_refresh_btn,
			*index_find_in_pages_combo;

	/* Combos on manpage view panel. */
	GtkWidget	*manpage_combo,
			*section_combo,
			*find_combo;

	/* Important menu items. */
	GtkWidget	*file_mh,
			*open_mi,
			*clear_mi,
			*close_mi,
			*exit_mi,

			*edit_mh,
			*edit_preferences,

			*view_mh,
			*view_view_mi,
			*view_index_mi,

			*windows_mh,
			*windows_new_editor,
			*windows_new_viewer;

	/* Tool bar buttons. */
	GtkWidget	*open_btn,
			*clear_btn,
			*stop_btn;


	/* Right click menu over view_text. */
	GtkWidget	*view_menu,
			*view_open_mi,
			*view_clear_mi;

	/* Right click menu over index_ctree. */
	GtkWidget	*index_menu,
			*index_expand_mi,
			*index_parent_mi,
			*index_goto_mi,
			*index_refresh_mi,
			*index_stop_mi;

        /* Status bar. */
        GtkWidget       *status_bar_dock,
                        *status_bar_toplevel,   /* An hbox. */
                        *status_bar_progress,
                        *status_bar_label,
                        *status_bar_cursor_label;

	/* Last progress position value from 0.0 to 1.0. */
	gfloat status_bar_progress_pos_last;

	/* Currently loaded manual page path (if any). */
	gchar *cur_manpage_path;

	/* Name of current manpage, this is to match up to see if
	 * newly loaded manpage is the same. Note that this is not
	 * the file name, rather it should be the name from the
	 * manual page's header.
	 */
	gchar *cur_manpage_name;

	/* Last scroll positions. */
	gfloat	last_scroll_hpos,	/* Not used. */
		last_scroll_vpos;

	/* Last manual page output file opened path. */
	gchar *last_open_path;

} viewer_struct;


extern viewer_index_item_struct *ViewerIndexItemNew(
	gint type,	/* One of ViewerIndexItemType*. */
	const char *file_name_full
);
extern void ViewerIndexItemDelete(viewer_index_item_struct *item_ptr);
extern void ViewerBranchSelect(
        viewer_struct *v, GtkCTreeNode *branch
);

extern void ViewerTextInsertPosition(viewer_struct *v, gint start_pos);
extern void ViewerTextInsert(
	viewer_struct *v, const gchar *buf, gint buf_len,
	gpointer client_data, gint (*func_cb)(glong, glong, gpointer)
);
extern void ViewerTextDelete(viewer_struct *v, gint start_pos, gint end_pos); 
extern void ViewerIndexDoLoad(
        viewer_struct *v,
        const gchar **path, gint total_paths,
	const gchar **name
);

extern gbool ViewerDoFind(
        viewer_struct *v, GtkText *text,
        gchar *haystack, gchar *needle,
        gint haystack_len, gint start_pos,
        gbool case_sensitive,
        gbool move_to,
        gbool *search_wrapped
);

extern void ViewerViewTextRecordScrollPositions(viewer_struct *v);

extern void ViewerSetBusy(viewer_struct *v);
extern void ViewerSetReady(viewer_struct *v);

extern viewer_struct *ViewerNew(gpointer core_ptr, gint editor_num);
extern void ViewerUpdateMenus(viewer_struct *v);
extern void ViewerSetStatusPosition(viewer_struct *v, gint row, gint column);
extern void ViewerSetStatusMessage(viewer_struct *v, const gchar *mesg);
extern void ViewerSetStatusProgress(viewer_struct *v, gfloat percent);
extern void ViewerRecordPositions(viewer_struct *v);
extern void ViewerReset(viewer_struct *v, gbool need_unmap);
extern void ViewerMap(viewer_struct *v);
extern void ViewerUnmap(viewer_struct *v);
extern void ViewerDelete(viewer_struct *v);


#endif	/* VIEWER_H */
