/*  The Blue Mango Quest
 *  Copyright (c) Clment 'phneutre' Bourdarias (code)
 *                   email: phneutre@users.sourceforge.net
 *                Guillaume 'GuBuG' Burlet (graphics)
 *                   email: gubug@users.sourceforge.net
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef WIN32
#include <windows.h>
#endif

#include <GL/gl.h>
#include <GL/glu.h>
#include <stdio.h>
#include "geom_bonus.h"

static short CR_face_indicies[108][9] = {
// ChamferBox
  {0, 2, 3, 0, 1, 2, 0, 1, 2}, {0, 3, 1, 0, 2, 3, 0, 2, 3}, {0, 4, 5, 0, 4, 5,
                                                             0, 4, 5},
  {0, 5, 6, 0, 5, 6, 0, 5, 6}, {0, 6, 7, 0, 6, 7, 0, 6, 7}, {0, 7, 2, 0, 7, 1,
                                                             0, 7, 1},
  {2, 7, 8, 1, 7, 8, 1, 7, 8}, {2, 8, 9, 1, 8, 9, 1, 8, 9}, {2, 9, 10, 1, 9,
                                                             10, 1, 9, 10},
  {2, 10, 3, 1, 10, 2, 1, 10, 2}, {3, 10, 11, 2, 10, 11, 2, 10, 11}, {3, 11,
                                                                      12, 2,
                                                                      11, 12,
                                                                      2, 11,
                                                                      12},
  {3, 12, 13, 2, 12, 13, 2, 12, 13}, {3, 13, 1, 2, 13, 3, 2, 13, 3}, {1, 13,
                                                                      14, 3,
                                                                      13, 14,
                                                                      3, 13,
                                                                      14},
  {1, 14, 15, 3, 14, 15, 3, 14, 15}, {1, 15, 4, 3, 15, 4, 3, 15, 4}, {1, 4, 0,
                                                                      3, 4, 0,
                                                                      3, 4,
                                                                      0},
  {4, 16, 17, 16, 17, 18, 16, 17, 18}, {4, 17, 5, 19, 18, 19, 16, 18, 19},
  {5, 17, 18, 20, 20, 21, 20, 21, 22}, {5, 18, 6, 22, 21, 22, 20, 22, 23},
  {6, 18, 19, 23, 21, 24, 23, 22, 24}, {6, 19, 7, 23, 24, 23, 23, 24, 25},
  {7, 19, 20, 25, 24, 26, 25, 24, 26}, {7, 20, 8, 27, 26, 27, 25, 26, 27},
  {8, 20, 21, 28, 28, 29, 28, 29, 30}, {8, 21, 9, 30, 29, 30, 28, 30, 31},
  {9, 21, 22, 31, 29, 32, 31, 30, 17}, {9, 22, 10, 31, 32, 31, 31, 17, 16},
  {10, 22, 23, 33, 32, 34, 16, 17, 18}, {10, 23, 11, 35, 34, 35, 16, 18, 19},
  {11, 23, 24, 36, 36, 37, 20, 21, 22}, {11, 24, 12, 38, 37, 38, 20, 22, 23},
  {12, 24, 25, 39, 37, 40, 23, 22, 24}, {12, 25, 13, 39, 40, 39, 23, 24, 25},
  {13, 25, 26, 41, 40, 42, 25, 24, 26}, {13, 26, 14, 43, 42, 43, 25, 26, 27},
  {14, 26, 27, 44, 44, 45, 28, 29, 30}, {14, 27, 15, 46, 45, 46, 28, 30, 31},
  {15, 27, 16, 47, 45, 17, 31, 30, 17}, {15, 16, 4, 47, 17, 47, 31, 17, 16},
  {16, 28, 29, 48, 48, 48, 17, 32, 33}, {16, 29, 17, 48, 48, 48, 17, 33, 18},
  {17, 29, 30, 49, 49, 50, 21, 34, 35}, {17, 30, 18, 49, 50, 49, 21, 35, 22},
  {18, 30, 31, 51, 50, 52, 22, 35, 36}, {18, 31, 19, 51, 52, 51, 22, 36, 24},
  {19, 31, 32, 53, 52, 53, 24, 36, 37}, {19, 32, 20, 53, 53, 53, 24, 37, 26},
  {20, 32, 33, 54, 54, 55, 29, 38, 39}, {20, 33, 21, 54, 55, 54, 29, 39, 30},
  {21, 33, 34, 56, 55, 57, 30, 39, 32}, {21, 34, 22, 56, 57, 56, 30, 32, 17},
  {22, 34, 35, 58, 57, 58, 17, 32, 33}, {22, 35, 23, 58, 58, 58, 17, 33, 18},
  {23, 35, 36, 59, 59, 60, 21, 34, 35}, {23, 36, 24, 59, 60, 59, 21, 35, 22},
  {24, 36, 37, 61, 60, 62, 22, 35, 36}, {24, 37, 25, 61, 62, 61, 22, 36, 24},
  {25, 37, 38, 63, 62, 63, 24, 36, 37}, {25, 38, 26, 63, 63, 63, 24, 37, 26},
  {26, 38, 39, 64, 64, 65, 29, 38, 39}, {26, 39, 27, 64, 65, 64, 29, 39, 30},
  {27, 39, 28, 66, 65, 66, 30, 39, 32}, {27, 28, 16, 66, 66, 66, 30, 32, 17},
  {28, 40, 41, 67, 68, 69, 32, 10, 40}, {28, 41, 29, 70, 69, 70, 32, 40, 33},
  {29, 41, 42, 71, 71, 72, 34, 41, 42}, {29, 42, 30, 73, 72, 73, 34, 42, 35},
  {30, 42, 43, 74, 72, 75, 35, 42, 43}, {30, 43, 31, 74, 75, 74, 35, 43, 36},
  {31, 43, 44, 76, 75, 77, 36, 43, 44}, {31, 44, 32, 78, 77, 78, 36, 44, 37},
  {32, 44, 45, 79, 79, 80, 38, 45, 46}, {32, 45, 33, 81, 80, 81, 38, 46, 39},
  {33, 45, 46, 82, 80, 83, 39, 46, 10}, {33, 46, 34, 82, 83, 82, 39, 10, 32},
  {34, 46, 47, 84, 83, 85, 32, 10, 40}, {34, 47, 35, 86, 85, 86, 32, 40, 33},
  {35, 47, 48, 87, 87, 88, 34, 41, 42}, {35, 48, 36, 89, 88, 89, 34, 42, 35},
  {36, 48, 49, 90, 88, 91, 35, 42, 43}, {36, 49, 37, 90, 91, 90, 35, 43, 36},
  {37, 49, 50, 92, 91, 93, 36, 43, 44}, {37, 50, 38, 94, 93, 94, 36, 44, 37},
  {38, 50, 51, 95, 95, 96, 38, 45, 46}, {38, 51, 39, 97, 96, 97, 38, 46, 39},
  {39, 51, 40, 98, 96, 68, 39, 46, 10}, {39, 40, 28, 98, 68, 98, 39, 10, 32},
  {40, 55, 41, 99, 100, 99, 47, 48, 49}, {41, 55, 42, 101, 100, 101, 49, 48,
                                          50},
  {42, 55, 53, 102, 100, 103, 50, 48, 51}, {42, 53, 43, 102, 103, 102, 50, 51,
                                            52},
  {43, 53, 44, 104, 103, 104, 52, 51, 53}, {44, 53, 45, 105, 103, 105, 53, 51,
                                            54},
  {45, 53, 52, 106, 103, 107, 54, 51, 55}, {45, 52, 46, 106, 107, 106, 54, 55,
                                            56},
  {46, 52, 47, 108, 107, 108, 56, 55, 57}, {47, 52, 48, 109, 107, 109, 57, 55,
                                            58},
  {48, 52, 54, 110, 107, 111, 58, 55, 59}, {48, 54, 49, 110, 111, 110, 58, 59,
                                            60},
  {49, 54, 50, 112, 111, 112, 60, 59, 61}, {50, 54, 51, 113, 111, 113, 61, 59,
                                            62},
  {51, 54, 55, 114, 111, 100, 62, 59, 48}, {51, 55, 40, 114, 100, 114, 62, 48,
                                            47},
  {54, 52, 53, 111, 107, 103, 59, 55, 51}, {54, 53, 55, 111, 103, 100, 59, 51,
                                            48}
};
static GLfloat CR_vertices[56][3] = {
  {-0.21f, 0.21f, 0.25f}, {0.21f, 0.21f, 0.25f}, {-0.21f, -0.21f, 0.25f},
  {0.21f, -0.21f, 0.25f}, {-0.21f, 0.238284f, 0.238284f}, {-0.23f, 0.23f,
                                                           0.238284f},
  {-0.238284f, 0.21f, 0.238284f}, {-0.238284f, -0.21f, 0.238284f}, {-0.23f,
                                                                    -0.23f,
                                                                    0.238284f},
  {-0.21f, -0.238284f, 0.238284f}, {0.21f, -0.238284f, 0.238284f}, {0.23f,
                                                                    -0.23f,
                                                                    0.238284f},
  {0.238284f, -0.21f, 0.238284f}, {0.238284f, 0.21f, 0.238284f}, {0.23f,
                                                                  0.23f,
                                                                  0.238284f},
  {0.21f, 0.238284f, 0.238284f}, {-0.21f, 0.25f, 0.21f}, {-0.238284f,
                                                          0.238284f, 0.21f},
  {-0.25f, 0.21f, 0.21f}, {-0.25f, -0.21f, 0.21f}, {-0.238284f, -0.238284f,
                                                    0.21f},
  {-0.21f, -0.25f, 0.21f}, {0.21f, -0.25f, 0.21f}, {0.238284f, -0.238284f,
                                                    0.21f},
  {0.25f, -0.21f, 0.21f}, {0.25f, 0.21f, 0.21f}, {0.238284f, 0.238284f,
                                                  0.21f},
  {0.21f, 0.25f, 0.21f}, {-0.21f, 0.25f, -0.21f}, {-0.238284f, 0.238284f,
                                                   -0.21f},
  {-0.25f, 0.21f, -0.21f}, {-0.25f, -0.21f, -0.21f}, {-0.238284f, -0.238284f,
                                                      -0.21f},
  {-0.21f, -0.25f, -0.21f}, {0.21f, -0.25f, -0.21f}, {0.238284f, -0.238284f,
                                                      -0.21f},
  {0.25f, -0.21f, -0.21f}, {0.25f, 0.21f, -0.21f}, {0.238284f, 0.238284f,
                                                    -0.21f},
  {0.21f, 0.25f, -0.21f}, {-0.21f, 0.238284f, -0.238284f}, {-0.23f, 0.23f,
                                                            -0.238284f},
  {-0.238284f, 0.21f, -0.238284f}, {-0.238284f, -0.21f, -0.238284f}, {-0.23f,
                                                                      -0.23f,
                                                                      -0.238284f},
  {-0.21f, -0.238284f, -0.238284f}, {0.21f, -0.238284f, -0.238284f}, {0.23f,
                                                                      -0.23f,
                                                                      -0.238284f},
  {0.238284f, -0.21f, -0.238284f}, {0.238284f, 0.21f, -0.238284f}, {0.23f,
                                                                    0.23f,
                                                                    -0.238284f},
  {0.21f, 0.238284f, -0.238284f}, {0.21f, -0.21f, -0.25f}, {-0.21f, -0.21f,
                                                            -0.25f},
  {0.21f, 0.21f, -0.25f}, {-0.21f, 0.21f, -0.25f}
};
static GLfloat CR_normals[115][3] = {
  {-0.191562f, 0.135167f, 0.972129f}, {-0.157641f, -0.223413f, 0.961892f},
    {0.191562f, -0.135167f, 0.972129f},
  {0.157641f, 0.223413f, 0.961892f}, {-0.0523296f, 0.382159f, 0.922614f},
    {-0.270598f, 0.270598f, 0.923879f},
  {-0.381502f, 0.0785214f, 0.921027f}, {-0.382159f, -0.0523296f, 0.922614f},
    {-0.270598f, -0.270598f, 0.923879f},
  {-0.0785214f, -0.381502f, 0.921027f}, {0.0523296f, -0.382159f, 0.922614f},
    {0.270598f, -0.270598f, 0.923879f},
  {0.381502f, -0.0785214f, 0.921027f}, {0.382159f, 0.0523296f, 0.922614f},
    {0.270598f, 0.270598f, 0.923879f},
  {0.0785214f, 0.381502f, 0.921027f}, {-0.357407f, 0.862856f, 0.357407f},
    {-0.120924f, 0.9171f, 0.379876f},
  {-0.357407f, 0.862856f, 0.357407f}, {-0.357406f, 0.862856f, 0.357406f},
    {-0.862856f, 0.357407f, 0.357407f},
  {-0.896453f, 0.241847f, 0.371323f}, {-0.862856f, 0.357406f, 0.357407f},
    {-0.923879f, 0.0f, 0.382684f},
  {-0.9171f, -0.120924f, 0.379876f}, {-0.862856f, -0.357407f, 0.357407f},
    {-0.862856f, -0.357407f, 0.357407f},
  {-0.862856f, -0.357406f, 0.357406f}, {-0.357407f, -0.862856f, 0.357407f},
    {-0.241847f, -0.896453f, 0.371323f},
  {-0.357406f, -0.862856f, 0.357407f}, {0.0f, -0.923879f, 0.382684f},
    {0.120924f, -0.9171f, 0.379876f},
  {0.357407f, -0.862856f, 0.357407f}, {0.357407f, -0.862856f, 0.357407f},
    {0.357406f, -0.862856f, 0.357406f},
  {0.862856f, -0.357407f, 0.357407f}, {0.896453f, -0.241847f, 0.371323f},
    {0.862856f, -0.357406f, 0.357407f},
  {0.923879f, 0.0f, 0.382684f}, {0.9171f, 0.120924f, 0.379876f}, {0.862856f,
                                                                  0.357407f,
                                                                  0.357407f},
  {0.862856f, 0.357407f, 0.357407f}, {0.862856f, 0.357406f, 0.357406f},
    {0.357407f, 0.862856f, 0.357407f},
  {0.241847f, 0.896453f, 0.371323f}, {0.357406f, 0.862856f, 0.357407f}, {0.0f,
                                                                         0.923879f,
                                                                         0.382684f},
  {-0.382684f, 0.923879f, 0.0f}, {-0.923879f, 0.382684f, 0.0f}, {-0.965729f,
                                                                 0.259551f,
                                                                 0.0f},
  {-1.0f, 0.0f, 0.0f}, {-0.991543f, -0.129775f, 0.0f}, {-0.923879f,
                                                        -0.382684f, 0.0f},
  {-0.382684f, -0.923879f, 0.0f}, {-0.259551f, -0.965729f, 0.0f}, {0.0f,
                                                                   -1.0f,
                                                                   0.0f},
  {0.129775f, -0.991543f, 0.0f}, {0.382684f, -0.923879f, 0.0f}, {0.923879f,
                                                                 -0.382684f,
                                                                 0.0f},
  {0.965729f, -0.259551f, 0.0f}, {1.0f, 0.0f, 0.0f}, {0.991543f, 0.129775f,
                                                      0.0f},
  {0.923879f, 0.382684f, 0.0f}, {0.382684f, 0.923879f, 0.0f}, {0.259551f,
                                                               0.965729f,
                                                               0.0f},
  {0.0f, 1.0f, 0.0f}, {-0.357406f, 0.862856f, -0.357407f}, {-0.120924f,
                                                            0.9171f,
                                                            -0.379876f},
  {-0.357407f, 0.862856f, -0.357407f}, {-0.357407f, 0.862856f, -0.357407f},
    {-0.862856f, 0.357406f, -0.357406f},
  {-0.896453f, 0.241847f, -0.371323f}, {-0.862856f, 0.357407f, -0.357407f},
    {-0.923879f, 0.0f, -0.382684f},
  {-0.9171f, -0.120924f, -0.379876f}, {-0.862856f, -0.357406f, -0.357407f},
    {-0.862856f, -0.357407f, -0.357407f},
  {-0.862856f, -0.357407f, -0.357407f}, {-0.357406f, -0.862856f, -0.357406f},
    {-0.241847f, -0.896453f, -0.371323f},
  {-0.357407f, -0.862856f, -0.357407f}, {0.0f, -0.923879f, -0.382684f},
    {0.120924f, -0.9171f, -0.379876f},
  {0.357406f, -0.862856f, -0.357407f}, {0.357407f, -0.862856f, -0.357407f},
    {0.357407f, -0.862856f, -0.357407f},
  {0.862856f, -0.357406f, -0.357406f}, {0.896453f, -0.241847f, -0.371323f},
    {0.862856f, -0.357407f, -0.357407f},
  {0.923879f, 0.0f, -0.382684f}, {0.9171f, 0.120924f, -0.379876f}, {0.862856f,
                                                                    0.357406f,
                                                                    -0.357407f},
  {0.862856f, 0.357407f, -0.357407f}, {0.862856f, 0.357407f, -0.357407f},
    {0.357406f, 0.862856f, -0.357406f},
  {0.241847f, 0.896453f, -0.371323f}, {0.357407f, 0.862856f, -0.357407f},
    {0.0f, 0.923879f, -0.382684f},
  {-0.156558f, 0.377965f, -0.912487f}, {-0.157641f, 0.223413f, -0.961892f},
    {-0.377965f, 0.156558f, -0.912487f},
  {-0.382684f, 0.0f, -0.923879f}, {-0.191562f, -0.135167f, -0.972129f},
    {-0.377965f, -0.156558f, -0.912487f},
  {-0.156558f, -0.377965f, -0.912487f}, {0.0f, -0.382684f, -0.923879f},
    {0.157641f, -0.223413f, -0.961892f},
  {0.156558f, -0.377965f, -0.912487f}, {0.377965f, -0.156558f, -0.912487f},
    {0.382684f, 0.0f, -0.923879f},
  {0.191562f, 0.135167f, -0.972129f}, {0.377965f, 0.156558f, -0.912487f},
    {0.156558f, 0.377965f, -0.912487f},
  {0.0f, 0.382684f, -0.923879f}
};
static GLfloat CR_textures[63][2] = {
  {0.0804198f, 0.91958f}, {0.0804196f, 0.0804198f}, {0.91958f, 0.0804195f},
  {0.91958f, 0.91958f}, {0.0804198f, 0.976092f}, {0.0404598f, 0.95954f},
  {0.0239078f, 0.91958f}, {0.0239076f, 0.0804198f}, {0.0404596f, 0.0404598f},
  {0.0804196f, 0.0239078f}, {0.91958f, 0.0239075f}, {0.95954f, 0.0404595f},
  {0.976092f, 0.0804195f}, {0.976092f, 0.91958f}, {0.95954f, 0.95954f},
  {0.91958f, 0.976092f}, {0.91958f, 0.976092f}, {0.91958f, 0.91958f},
  {0.976092f, 0.91958f}, {0.95954f, 0.976092f}, {0.0404595f, 0.976092f},
  {0.0239076f, 0.91958f}, {0.0804196f, 0.91958f}, {0.0804196f, 0.976092f},
  {0.91958f, 0.91958f}, {0.91958f, 0.976092f}, {0.976092f, 0.91958f},
  {0.95954f, 0.976092f}, {0.0404596f, 0.976092f}, {0.0239076f, 0.91958f},
  {0.0804196f, 0.91958f}, {0.0804196f, 0.976092f}, {0.91958f, 0.0804196f},
  {0.976092f, 0.0804196f}, {0.0239076f, 0.0804196f}, {0.0804196f, 0.0804196f},
  {0.91958f, 0.0804196f}, {0.976092f, 0.0804196f}, {0.0239076f, 0.0804196f},
  {0.0804196f, 0.0804196f}, {0.95954f, 0.0239075f}, {0.0404595f, 0.0239075f},
  {0.0804196f, 0.0239075f}, {0.91958f, 0.0239075f}, {0.95954f, 0.0239075f},
  {0.0404596f, 0.0239075f}, {0.0804196f, 0.0239075f}, {0.91958f, 0.976092f},
  {0.91958f, 0.91958f}, {0.95954f, 0.95954f}, {0.976092f, 0.91958f},
  {0.91958f, 0.0804198f}, {0.976092f, 0.0804198f}, {0.95954f, 0.0404598f},
  {0.91958f, 0.0239078f}, {0.0804198f, 0.0804195f}, {0.0804198f, 0.0239075f},
  {0.0404598f, 0.0404595f}, {0.0239078f, 0.0804195f}, {0.0804196f, 0.91958f},
  {0.0239076f, 0.91958f}, {0.0404596f, 0.95954f}, {0.0804196f, 0.976092f}
};

GLint genListeCubeRond()
{
  unsigned int i;
  int j;
  GLint lid = 0;

  lid = glGenLists(1);
  glNewList(lid, GL_COMPILE);

  glBegin(GL_TRIANGLES);
  for (i = 0; i < sizeof(CR_face_indicies) / sizeof(CR_face_indicies[0]); i++)
  {
    for (j = 0; j < 3; j++)
    {
      int vi = CR_face_indicies[i][j];
      int ni = CR_face_indicies[i][j + 3]; // Normal index
      int ti = CR_face_indicies[i][j + 6]; // Texture index

      glNormal3f(CR_normals[ni][0], CR_normals[ni][1], CR_normals[ni][2]);
      glTexCoord2f(CR_textures[ti][0], CR_textures[ti][1]);
      glVertex3f(CR_vertices[vi][0], CR_vertices[vi][1], CR_vertices[vi][2]);
    }
  }
  glEnd();

  glEndList();
  return lid;
};
