#ifndef _FOYER_H
#define _FOYER_H

// status of huts
#define ETAT_FONCTIONNE 0
#define ETAT_DETRUIT 1
#define ETAT_FREEZE 2

// status of shmolluxs
#define ETAT_NAISSANCE 6
#define ETAT_POURSUIVANT 0
#define ETAT_POURSUIVI 1
#define ETAT_STOP 2
#define ETAT_MORT 3

#define VITESSE_TRANS_V_SHMOL 0.006
#define VITESSE_TRANS_L_SHMOL 0.01

#define SHMOL_GAUCHE 0
#define SHMOL_DROITE 1
#define SHMOL_HAUT 2
#define SHMOL_BAS 3

struct shmollux_t
{
  double pos_x, pos_z;
  int map_x, map_z;

  void *my_sector;

  char status, old_status;
  char direction;
  double speed[2];

  char need_choice;
  int square_last_test;
  int my_address;
  int square;

  char possible_dir[4];
  char possible_dir_before[4];

  GLuint *my_textures;
};

struct hut_t
{
  int total_num_shmol;
  int num_shmol_here;
  char status;
  int square;

  double pos_x, pos_z;

  GLfloat coordTriangles[4][2]; //4 vertices, and we don't need Y coord
  GLuint hut_tex[2];

  GLuint *shmol_tex;

  CHRONOMETRE *timer;
  char doors_open;

  shmollux_t *shmollux;
};

int register_huts();
void load_huts_geom();
void build_hut_texture(hut_t *hut);
void cleanup_huts_and_shmolluxes();

void  all_shmol_go_home();

void load_hut_textures(hut_t *hut);
void init_shmollux();
void shmol_procreation(shmollux_t *shmollux);
void return_home(shmollux_t *shmollux);
void shmol_hunt(shmollux_t *shmollux);
void shmol_escape(shmollux_t *shmollux);
void shmol_move(shmollux_t *shmollux);
int analyze_situation(shmollux_t *shmollux);
void choose_direction(int how_many_choices, shmollux_t *shmollux);
void shmol_move_forward(shmollux_t *shmollux);
void draw_shmollux(shmollux_t *shmollux);

void draw_hut(hut_t *hut);
void manage_shmollux_exit(hut_t *hut);
void update_shmollux(hut_t *hut);
void interaction_player_shmol(shmollux_t *shmollux);

void change_hut_status(hut_t *hut, char new_status);
void change_shmol_status(hut_t *hut, char new_status);
void shockWave(hut_t *hut, int range);

void cleanup_huts_geom();
void proximity_warning();
#endif
