#ifdef WIN32
#include <windows.h>
#endif
#include <GL/gl.h>
#include <GL/glu.h>
#include <SDL/SDL.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#ifdef HAVE_SDL_MIXER
# include <SDL/SDL_mixer.h>
#endif

#include "timers.h"
#include "world_building.h"
#include "world_geometry.h"
#include "hut.h"
#include "bonus.h"
#include "mango.h"
#include "map.h"

extern game_data_t *world;

unsigned char test_left(int pos)
{
  if (pos % world->size == 0)
  {
    return 0;
  }                             // on est sur le mur gauche

  if (world->map[pos - 1].tex_mur > -1)
    return 1;

  else
    return 0;
}

unsigned char test_right(int pos)
{
  if (pos % world->size == (world->size - 1))
  {
    return 0;
  }                             // on est sur le mur droit

  if (world->map[pos + 1].tex_mur > -1)
    return 1;
  else
    return 0;

}

unsigned char test_up(int pos)
{
  if (pos < world->size)
  {
    return 0;
  }                             // on est sur le mur haut

  if (world->map[pos - world->size].tex_mur > -1)
    return 1;
  else
    return 0;
}

unsigned char test_down(int pos)
{
  if (floor(pos / world->size) == (world->size - 1))
  {
    return 0;
  }
  // (on est sur le mur bas)

  if (world->map[pos + world->size].tex_mur > -1)
    return 1;
  else
    return 0;
}

unsigned char test_up_right(int pos)
{
  if (pos < world->size)
  {
    return 0;
  }                             // on est sur le mur haut
  if (pos % world->size == (world->size - 1))
  {
    return 0;
  }                             // on est sur le mur droit

  if (world->map[pos - world->size + 1].tex_mur > -1)
    return 1;
  else
    return 0;
}

unsigned char test_up_left(int pos)
{
  if (pos < world->size)
  {
    return 0;
  }                             // on est sur le mur haut
  if (pos % world->size == 0)
  {
    return 0;
  }                             // on est sur le mur gauche

  if (world->map[pos - world->size - 1].tex_mur > -1)
    return 1;
  else
    return 0;
}

unsigned char test_down_left(int pos)
{
  if (floor(pos / world->size) == (world->size - 1))
  {
    return 0;
  }                             // (on est sur le mur bas)
  if (pos % world->size == 0)
  {
    return 0;
  }                             // on est sur le mur gauche

  if (world->map[pos + world->size - 1].tex_mur > -1)
    return 1;
  else
    return 0;
}

unsigned char test_down_right(int pos)
{
  if (floor(pos / world->size) == (world->size - 1))
  {
    return 0;
  }                             // (on est sur le mur bas)
  if (pos % world->size == (world->size - 1))
  {
    return 0;
  }                             // on est sur le mur gauche

  if (world->map[pos + world->size + 1].tex_mur > -1)
    return 1;
  else
    return 0;
}

int get_left(int pos)
{
  int result;
  // on suppose que la valeur de pos est correcte
  if (pos % world->size == 0)
  {
    return -1;
  }                             // on est sur le mur gauche

  result = pos - 1;
  return result;
}

int get_right(int pos)
{
  int result;
  if (pos % world->size == (world->size - 1))
  {
    return -1;
  }                             // on est sur le mur droit

  result=pos + 1;
  return result;
}

int get_up(int pos)
{
  int result;
  if (pos < world->size)
  {
    return -1;
  }                             // on est sur le mur haut

  result=pos - world->size;
  return result;
}

int get_down(int pos)
{
  int result;
  if (floor(pos / world->size) == (world->size - 1))
  {
    return -1;
  }
  result=pos + world->size;
  return result;
}

int test_bonus(int pos)
{
  if (world->map[pos].bonus == -1)
  {
    if (world->map[pos].is_ditugomme)
    {
      return E_DITUBOITE;
    }
    else
      return E_RIEN;
  }

  else if (world->map[pos].bonus >= 0)
  {
    return world->map[pos].bonus;
  }

  else
    return E_RIEN;
}

int test_special(int pos)
{
  if (world->map[pos].special == -1)
  {
    return E_RIEN;
  }

  else if (world->map[pos].special >= 0)
  {
    return world->map[pos].special;
  }

  // just to be sure
  else
    return E_RIEN;
}

int square_to_map_x(int square)
{
  int map_x;
  map_x = (int)(square % world->size);
  return map_x;
}

int square_to_map_z(int square)
{
  int map_z;
  map_z = (int)floor(square / world->size);
  return map_z;
}

int map_to_square(int x, int z)
{
  int square=0;
  square = z * world->size + x;
  return square;
}

int get_bonus_param(int square)
{
  return world->map[square].paramBonus;
}

int is_teleport(int square)
{
  int typeSpecial=0;
  typeSpecial = test_special(square);
  if ((typeSpecial >= TEL_D1)&&(typeSpecial <= TEL_A5))
    return 1;

  else return 0;
}
