/*  The Blue Mango Quest
 *  Copyright (c) Clment 'phneutre' Bourdarias (code)
 *                   email: phneutre@users.sourceforge.net
 *                Guillaume 'GuBuG' Burlet (graphics)
 *                   email: gubug@users.sourceforge.net
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef WIN32
#include <windows.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <GL/gl.h>
#include <GL/glu.h>
#include <SDL/SDL.h>

#ifdef HAVE_SDL_MIXER
# include <SDL/SDL_mixer.h>
#endif

#include <math.h>
#include <string.h>

#include "font.h"

#include "timers.h"
#include "world_geometry.h"
#include "hut.h"
#include "bonus.h"
#include "mango.h"
#include "world_building.h"
#include "texture.h"
#include "sector.h"
#include "map.h"
#include "system_gl.h"
#include "draw_scene_gl.h"
#include "hud.h"

extern player_t *player;
extern game_data_t *world;
extern char *filename;
extern hud_t *hud;

void draw_big_hud_map()
{
#define TOTAL_GRID_LENGTH 420
#define GRID_X1 180
#define GRID_Z1 70

  glLineWidth(0.5);
  glDisable(GL_TEXTURE_2D);

  glPushMatrix();
  glTranslatef(GRID_X1,GRID_Z1,0.0);

  draw_big_hud_map_walls_and_bonus();
  draw_big_hud_map_player();
  draw_big_hud_map_shmolluxes();
  
  //glEnable(GL_TEXTURE_2D);
  glColor3f(1.0,1.0,1.0); 

  glPopMatrix();
}

void draw_big_hud_map_walls_and_bonus()
{
  GLfloat x1=0,z1=0;
  GLfloat square_length=0;

  glColor3f(1.0,1.0,1.0);  

  square_length = TOTAL_GRID_LENGTH/world->size;
  /* draw walls */
  for (int i = 0; i < world->size_square; i++)
  {
    x1 = (i%world->size) * square_length;
    z1 = TOTAL_GRID_LENGTH-floor(i / world->size) * square_length;

    if (world->map[i].tex_mur > -1)
      {
	glBegin(GL_LINES);
	glVertex2f(x1+square_length,z1);
	glVertex2f(x1,z1-square_length);

	if (test_left(i)==0) {
	  glVertex2f(x1,z1);
	  glVertex2f(x1,z1-square_length);
	}

	if (test_right(i)==0) {
	  glVertex2f(x1+square_length,z1);
	  glVertex2f(x1+square_length,z1-square_length);
	}

	if (test_up(i)==0) {
	  glVertex2f(x1,z1);
	  glVertex2f(x1+square_length,z1);
	}

	if (test_down(i)==0) {
	  glVertex2f(x1,z1-square_length);
	  glVertex2f(x1+square_length,z1-square_length);
	}
	glEnd();
      }

    if (world->map[i].bonus == E_SHMIXGOMME) {
      glColor3f(0.4,0.9,0.4);
      draw_big_hud_map_triangle(x1+square_length*0.5,z1-square_length*0.5);
      glColor3f(1.0,1.0,1.0);
    }

    /*if (world->map[i].special == FINISH_POS) {
      glColor3f(0.4,0.4,0.4);
      draw_big_hud_map_losange(x1+square_length*0.5,z1-square_length*0.5);
      glColor3f(1.0,1.0,1.0);
    }*/
  }

  glEnd();
}

void draw_big_hud_map_cross(GLfloat cross_center_x, GLfloat cross_center_z)
{
  GLfloat x1=0,z1=0,x2=0,z2=0;
  GLfloat square_length = TOTAL_GRID_LENGTH/world->size;

  glBegin(GL_LINES);
  x1 = cross_center_x - square_length/4;
  z1 = cross_center_z + square_length/4;

  x2 = cross_center_x + square_length/4;
  z2 = cross_center_z - square_length/4;

  glVertex2f(x1,z1);
  glVertex2f(x2,z2);

  glVertex2f(x2,z1);
  glVertex2f(x1,z2);
  glEnd();
}

void draw_big_hud_map_triangle(GLfloat center_x, GLfloat center_z)
{
  GLfloat x1=0,z1=0,x2=0,x3=0,z2=0;
  GLfloat square_length = TOTAL_GRID_LENGTH/world->size;

  glBegin(GL_LINES);
  x1 = center_x;
  z1 = center_z + square_length/4;

  x2 = center_x - square_length/4;
  x3 = center_x + square_length/4;
  z2 = center_z - square_length/4;

  glVertex2f(x1,z1);
  glVertex2f(x2,z2);

  glVertex2f(x2,z2);
  glVertex2f(x3,z2);

  glVertex2f(x1,z1);
  glVertex2f(x3,z2);

  glEnd();
}

void draw_big_hud_map_arrow(GLfloat center_x, GLfloat center_z)
{
  GLfloat x1=0,z1=0,x2=0,x3=0,z2=0;
  GLfloat square_length = TOTAL_GRID_LENGTH/world->size;

  glBegin(GL_LINES);
  x1 = center_x;
  z1 = center_z + square_length/4;

  x2 = center_x - square_length/6;
  x3 = center_x + square_length/6;
  z2 = center_z - square_length/4;

  glVertex2f(x1,z1);
  glVertex2f(x2,z2);

  glVertex2f(x2,z2);
  glVertex2f(x3,z2);

  glVertex2f(x1,z1);
  glVertex2f(x3,z2);

  glEnd();
}

void draw_big_hud_map_losange(GLfloat center_x, GLfloat center_z)
{
  GLfloat x1=0,z1=0,x2=0,z2=0,x3=0;

  GLfloat square_length = TOTAL_GRID_LENGTH/world->size;

  glBegin(GL_LINES);
  x1 = center_x;
  z1 = center_z + square_length/4;

  x2 = center_x - square_length/4;
  z2 = center_z - square_length/4;

  x3 = center_x + square_length/4;

  glVertex2f(x1,z1);
  glVertex2f(x2,center_z);

  glVertex2f(x1,z1);
  glVertex2f(x3,center_z);

  glVertex2f(x2,center_z);
  glVertex2f(x1,z2);

  glVertex2f(x1,z2);
  glVertex2f(x3,center_z);

  glEnd();
}


void draw_big_hud_map_player()
{
  GLfloat center_x=0,center_z=0;
  GLfloat x1=0,z1=0,x2=0,x3=0,z2=0;
  GLfloat square_length = TOTAL_GRID_LENGTH/world->size;
  
  center_x=(player->pos_x/(world->size*SCALE_FACTOR))*TOTAL_GRID_LENGTH;
  center_z=TOTAL_GRID_LENGTH -(player->pos_z/(world->size*SCALE_FACTOR))*TOTAL_GRID_LENGTH;

  x1 = center_x;
  z1 = center_z + square_length/4;

  x2 = center_x - square_length/6;
  x3 = center_x + square_length/6;
  z2 = center_z - square_length/4;

  x1 = 0;
  z1 = square_length/4;
  x2 = -square_length/6;
  x3 = square_length/6;
  z2 = -square_length/4;

  glColor3f(0.1,0.1,0.9);
  glPushMatrix();  

  glTranslatef(center_x, center_z, .0f);
  glRotatef(player->y_rot, 0.0f, 0.0f, 1.0f);

  glBegin(GL_LINES);
  

  glVertex2f(x1,z1);
  glVertex2f(x2,z2);

  glVertex2f(x2,z2);
  glVertex2f(x3,z2);

  glVertex2f(x1,z1);
  glVertex2f(x3,z2);

  glEnd();

  
  glPopMatrix();
}

void draw_big_hud_map_shmolluxes()
{
  int i=0, j=0;
  hut_t *hut;
  shmollux_t *shmollux;

  GLfloat cross_x=0,cross_z=0;

  for (i=0; i < world->num_huts; i++)
    {
      hut = &world->huts[i];
      for (j=0; j < hut->total_num_shmol; j++)
	{
	  shmollux = &hut->shmollux[j];
	  
	  if ( (shmollux->status == ETAT_POURSUIVANT)
	       || (shmollux->status == ETAT_POURSUIVI)
	       || (shmollux->status == ETAT_STOP))

	    {
	      cross_x=(shmollux->pos_x/(world->size*SCALE_FACTOR))*TOTAL_GRID_LENGTH;
	      cross_z=TOTAL_GRID_LENGTH -(shmollux->pos_z/(world->size*SCALE_FACTOR))*TOTAL_GRID_LENGTH;

	      if (player->status != ETAT_POURSUIVANT)
		glColor3f(1.0,0.1,0.1);

	      else glColor3f(0.9,0.4,0.4);
	      
	      draw_big_hud_map_losange(cross_x,cross_z);
	    }
	}
    }
}
