/*  The Blue Mango Quest
 *  Copyright (c) Clment 'phneutre' Bourdarias (code)
 *                   email: phneutre@users.sourceforge.net
 *                Guillaume 'GuBuG' Burlet (graphics)
 *                   email: gubug@users.sourceforge.net
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _WORLD_GEOMETRY_H
#define _WORLD_GEOMETRY_H

#define SOL_1 0
#define SOL_2 1
#define PLAFOND_1 10
#define PLAFOND_2 11
#define MUR_1 20
#define MUR_2 21
#define MUR_3 22
#define MUR_4 23

#define HAUTEUR 4               // hauteur des murs
#define SCALE_FACTOR 3

#define HORIZ 1
#define VERTI 2

struct SOMMET2D
{
  double x, z;
  double u, v;
};

struct vertex_t
{
  double x, y, z;		// les coordonnees 3d
  double u, v;			// les coordonnees des textures
};

struct POINT2D
{
  double x, z;
};


struct triangle_t
{
  vertex_t vertex[3];
  int texture;			// le numero de la texture (0<= n< 36)
  char type;			// SOL, PLAFOND, MUR_1, MUR_2, MUR_3 ou MUR_4
  double normal_x, normal_y, normal_z;
};

struct CUBE			// une unite de base de labyrinthe
{
  triangle_t *triangles;		// les triangles constituant le cube
  int n_triangles;		// le nombre de triangles dans cette unite de carte
  triangle_t *trFBC,*trFCG,*trGCD,*trGDH,*trHDA,*trHAE,*trEAB,*trEBF;
  // pointeurs vers les triangles respectifs (cf. doc pour le nom des triangles)

};

struct bonus_t
{
  char visible;
  char still_here;
  
  double x;
  double y;
  double z;

  int square;
  int type;
  int parameter;
};

struct portal_t
{
  int number;
  char visible;

  double x1;
  double x2;
  double z1;
  double z2;
  char TYPE;
  
  // the problem is : struct sector_t is defined after portal_t
  // because sector_t contains portal_t
  // so... you see the problem.
  // consequently, this will be typecasted to sector_t * later.
  void *connexion1; 
  void *connexion2;
};

struct sector_t
{
  char visible;

  double xmin;
  double zmin;
  double xmax;
  double zmax;

  int num_portals;
  int *portal_indices;

  int num_triangles;
  triangle_t *triangles;

  int num_bonus;
  bonus_t *bonus;

};

class VECTEUR2D
{
 public:
  double x, z;
  double getNorme();
  double scalaire(VECTEUR2D v);
  double determinant(VECTEUR2D v);
  VECTEUR2D somme(VECTEUR2D v);
  void divisePar(double div);
  VECTEUR2D _divisePar(double div);

};

#endif
