/*
 * Copyright (c) 2001-2003 Shiman Associates Inc. All Rights Reserved.
 * 
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use, copy,
 * modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 */

#ifndef _AUTH_HOST_H
#define _AUTH_HOST_H

#define AUTH_HOST_ALL "*"

#define DEFAULT_HOST_LIST_SIZE 16

struct host_list
{
    char **hosts;
    int  members, allocated;
};

extern int32 auth_host_add_host( struct host_list *hl, char *hn );
extern int32 auth_host_remove_host( struct host_list *hl, char *hn );
extern int32 auth_host_allow_all( struct host_list *hl );
extern int32 auth_host_deny_all( struct host_list *hl );
extern int32 auth_host_authenticate( struct host_list *hl, char *hn );
extern int32 auth_host_authenticate_addr4( struct host_list *hl, int addr );
extern int32 auth_host_parse( struct host_list *hl, char *hn );

#endif /* _AUTH_HOST_H */
