/* matchbox - a lightweight window manager

   Copyright 2002 Matthew Allum

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
*/

#include "rcfile.h"

void rc_load(char *rcfilename)
{
   FILE *rcfp;
   char rcbuf[255];		/* buffer for conf file */
   char *tp;                    /* tmp pointer */
   
   if ((rcfp = fopen(rcfilename, "r")) == NULL)
    { 
      fprintf(stderr, "Cant conf file -  %s\n", rcfilename);
      exit(1);
    }
    
   while(fgets(rcbuf, sizeof(rcbuf), rcfp) != NULL)
   {
      char key[128], val[128];
      tp = &rcbuf[0];
      
      /* strip init spaces */
      while(*tp == ' ' || *tp == '\t') tp++;
      
      /* ignore comments and blank lines */
      if (*tp == '\n' || *tp == '#') continue;

      sscanf(tp, "%s%s", key, val); 
      hash_add(key,val);
   }
   fclose(rcfp);
}

char *rc_get(char *key)
{
   struct nlist *np;
   np = hash_lookup(key);
   if (np != NULL) return np->value;
   return NULL;
}

void rc_destroy()
{
   hash_empty();
}
