/* matchbox - a lightweight window manager

   Copyright 2002 Matthew Allum

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
*/

#ifndef _SELECT_CLIENT_H_
#define _SELECT_CLIENT_H_

#include <stdio.h>
#include <stdlib.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#ifdef USE_XFT
#include <X11/Xft/Xft.h>
#endif

#include "structs.h"
#include "base_client.h"
#include "client_common.h"
#include "main_client.h"
#include "select_client.h"
#include "dockbar_client.h"
#include "wm.h"
#include "misc.h"

#define ENTRY_SPC 6

client* select_client_new(wm *w);
void select_client_destroy(client *c);
void select_client_calc_dim(wm *w, int *width, int *height);
void select_client_button_press(client *c, XButtonEvent *e);
void select_client_init(client *c);
void select_client_reparent(client *c);
void select_client_redraw(client *c, Bool use_cache);

#endif



