/* matchbox - a lightweight window manager

   Copyright 2002 Matthew Allum

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
*/

#ifndef _STRUCTS_H_
#define _STRUCTS_H_

#include <stdio.h>
#include <stdlib.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#ifdef USE_XFT
#include <X11/Xft/Xft.h>
#endif

#define TRUE  1
#define FALSE 0

#define APPLY_GRAVITY 1
#define REMOVE_GRAVITY -1

#define DOCK_HEIGHT 16
#define DOCK_MIN_HEIGHT 4

#define STACK_REMOVE 1
#define STACK_ADD   -1

#define BUTTON_NEXT_PRESSED 1
#define BUTTON_PREV_PRESSED 2
#define BUTTON_CLOSE_PRESSED 3

#define MENU_FLAG   (1<<1)
#define SINGLE_FLAG (1<<2) /* hack to specify when only a single client */

#define Wm wm       /* tmp to avoid breakage */
#define Client client

#define START_CLIENT_LOOP(w,c) (c) = (w)->head_client; do {
#define END_CLIENT_LOOP(w,c)   } while (((c) = (c)->next) \
				        && ((c) != (w)->head_client) );

#define WBW(c) ((c)->wm->theme->win_border_width)

typedef enum { dialog, toolbar, detached, 
	       override, docked, menu, mainwin } Client_type;

typedef struct _client
{
   char	*name;
   XSizeHints	*size;
   Window	window, frame;
   struct _client *trans;
   Colormap	cmap;
   int		x, y, width, height;
   int		ignore_unmap;
   int          tmp_data;    /* must be a better way */

   Client_type type;
   Bool        shaded;				      // TOGO
   
#ifdef USE_XFT
    XftDraw     *xftdraw;
#endif

   void (* reparent)( struct _client* c );
   void (* redraw)( struct _client* c, Bool use_cache );
   void (* button_press) (struct _client *c, XButtonEvent *e);
   void (* move_resize)( struct _client* c );
   void (* configure)( struct _client* c );
   void (* get_coverage)( struct _client* c, int* x, int* y, int* h, int* w );
   void (* hide)( struct _client* c );
   void (* show)( struct _client* c );
   void (* destroy)( struct _client* c );

   Bool mapped;
   
   struct _client *next;
   struct _client *prev;

   Pixmap backing;

   void* xtra;
   struct _wm *wm;
   
} client;

typedef struct _pxm 
{
   Pixmap pixmap;
   Pixmap mask;
   int width;
   int height;
   
} Pxm ;

typedef enum { plain, gradient, pixmap } Theme_type;


typedef struct _theme 
{
   XFontStruct* font;
   XFontStruct* toolbar_font;
   
#ifdef USE_XFT
   XftFont *xftfont;
   XftFont *toolbar_xftfont;
   XftColor xft_fg;
#endif

   Pxm buttons[6];
   Pxm tile;
   
   int win_border_width;
   int padding;
   Bool bevel;
   
   XColor bg_col;                   /* for win borders, lines */
   XColor text_col;                 /* for text */
   XColor fg_col;                   /* main fg color */
   XColor fg_start_col, fg_end_col; /* for gradients & bevels */

   GC text_gc, toolbar_text_gc, bg_gc, fg_gc, effects_gc, mask_gc, invert_gc;
   
   Cursor move_curs, resize_curs;
   
} Theme;

typedef struct _wm_config
{
   Bool use_dock;
   Bool use_title;
   
   int dock_minheight;
   int dock_maxheight;

   unsigned int modifier;
   
   char theme_file[255];
   char display_name[128]; 

} Wm_config;

typedef struct _wm
{
   Display*     dpy;
   Atom         atoms[7];
   Window       root;
   int          screen;
   
   client*      head_client;    /* For ptr to beginning of list   */
   client*      focused_client; /* currently focused client       */
   client*      main_client;    /* currently viewable main client */
   XFontStruct* font;

   int dpy_width;
   int dpy_height;

   int lock; /* to go, replaced by flags */

   int flags;
   
   Window dockwin;
   int dockwin_offset;

   Cursor move_curs, resize_curs, curs;

   /* To do, set in an array */
   Atom wm_state, wm_change_state, wm_protos, wm_delete, wm_cmapwins,
      mb_theme, mb_command;

   Theme* theme;
   Wm_config *config;
} wm;


#endif
