/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.dependency.fromConfiguration;

import java.io.File;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.dependency.fromConfiguration.AbstractFromConfigurationMojo;
import org.apache.maven.plugin.dependency.fromConfiguration.ArtifactItem;
import org.apache.maven.plugin.dependency.utils.filters.ArtifactItemFilter;
import org.apache.maven.plugin.dependency.utils.filters.MarkerFileFilter;
import org.apache.maven.plugin.dependency.utils.markers.UnpackFileMarkerHandler;
import org.codehaus.plexus.util.StringUtils;

public final class UnpackMojo
extends AbstractFromConfigurationMojo {
    private File markersDirectory;
    private String includes;
    private String excludes;

    public void execute() throws MojoExecutionException {
        ArrayList processedItems = this.getProcessedArtifactItems(false);
        Iterator iter = ((AbstractList)processedItems).iterator();
        while (iter.hasNext()) {
            ArtifactItem artifactItem = (ArtifactItem)iter.next();
            if (artifactItem.isNeedsProcessing()) {
                this.unpackArtifact(artifactItem);
                continue;
            }
            this.getLog().info((CharSequence)(artifactItem.getArtifact().getFile().getName() + " already unpacked."));
        }
    }

    private void unpackArtifact(ArtifactItem artifactItem) throws MojoExecutionException {
        UnpackFileMarkerHandler handler = new UnpackFileMarkerHandler(artifactItem, this.markersDirectory);
        this.unpack(artifactItem.getArtifact().getFile(), artifactItem.getOutputDirectory(), artifactItem.getIncludes(), artifactItem.getExcludes());
        handler.setMarker();
    }

    ArtifactItemFilter getMarkedArtifactFilter(ArtifactItem item) {
        UnpackFileMarkerHandler handler = new UnpackFileMarkerHandler(item, this.markersDirectory);
        return new MarkerFileFilter(this.isOverWriteReleases(), this.isOverWriteSnapshots(), this.isOverWriteIfNewer(), handler);
    }

    protected ArrayList getProcessedArtifactItems(boolean removeVersion) throws MojoExecutionException {
        ArrayList items = super.getProcessedArtifactItems(removeVersion);
        Iterator iter = ((AbstractList)items).iterator();
        while (iter.hasNext()) {
            ArtifactItem artifactItem = (ArtifactItem)iter.next();
            if (StringUtils.isEmpty((String)artifactItem.getIncludes())) {
                artifactItem.setIncludes(this.getIncludes());
            }
            if (!StringUtils.isEmpty((String)artifactItem.getExcludes())) continue;
            artifactItem.setExcludes(this.getExcludes());
        }
        return items;
    }

    public File getMarkersDirectory() {
        return this.markersDirectory;
    }

    public void setMarkersDirectory(File theMarkersDirectory) {
        this.markersDirectory = theMarkersDirectory;
    }

    public String getExcludes() {
        return this.excludes;
    }

    public void setExcludes(String excludes) {
        this.excludes = excludes;
    }

    public String getIncludes() {
        return this.includes;
    }

    public void setIncludes(String includes) {
        this.includes = includes;
    }
}

