#!/devtool/local/bin/perl
use Net::FTP;
use File::Copy;

my $prefix = "D:/SAPDevelop/TOOLSRC/develop/sys/src/QATools/";
my $remoteprefix = "/SAP_DB/TESTDB";


my %passwd = (
'lcroot',	'Lroot',
'lroot',	'LC_root',
'remuser',	'Remuser',
'anonymous',	'd038447');

my %hosts = (
'us0062.wdf.sap.corp', 'lcroot',
'us4010.wdf.sap.corp', 'lcroot',
'ds0116.wdf.sap.corp', 'lcroot',
'is0025.wdf.sap.corp', 'lcroot',
'is0026.wdf.sap.corp', 'lcroot',
'ls0049.wdf.sap.corp', 'lroot',
'ls3007.wdf.sap.corp', 'remuser',
'hs0030.wdf.sap.corp', 'lcroot',
'hs0102.wdf.sap.corp', 'lcroot',
'hs0116.wdf.sap.corp', 'lcroot',
"10.18.106.1",         'lcroot',
'itanium21.nt5.sap-ag.de', 'anonymous'
);

my @winhosts = (
'pwdf2027',
'pwdf0238'
);



my @files = (
"database/qadb.pm",
"tests/asyncrun.pl",
"tests/chr_benchmark.pl",
"tests/chr_cmd.pl",
"tests/chr_create.pl",
"tests/chr_destroy.pl",
"tests/chr_doall.pl",
"tests/chr_gen.pl",
"tests/chr_install.pl",
"tests/chr_instid.pl",
"tests/chr_run.sh",
"tests/chr_run-a.sh",
"tests/chr_run-b.sh",
"tests/chr_single_test.pl",
"tests/chr_term.pl",
"tests/chr_term_su.pl",
"tests/chr_test.pl",
"tests/ml.pl",
"tests/motd-cleanup.pl",
"tests/testdb.pl",
#"tests/testdb.pm",
"tests/testdbchr.pl",
"tests/newtool.pl",
"tests/testdbchr.pm",
"tests/tp2.pl",
"tests/wisconsin.pl"
);


#
# Calc statistics
#

$nof = (scalar(keys(%hosts)) + scalar(@winhosts)) * scalar(@files);
$reached = 0;


foreach $host (keys(%hosts)) {
	#print $host . ": " . $hosts{$host} . " - " . $passwd{$hosts{$host}} . "\n";
	$ftp_hdl = Net::FTP->new($host, Debug => 0);
	$ftp_hdl->login($hosts{$host}, $passwd{$hosts{$host}});
	print $host . "\n";
	$ftp_hdl->binary();
	$ftp_hdl->cwd($remoteprefix);
	foreach $file (@files) {
		$reached ++;
		$outline = (split (/\./, $host))[0] . ":" . $file . " ";
		$left = 79 - length($outline);
		$cx = int ((($left + 0.0) / $nof) * $reached);
		$outline .= "x" x $cx;
		$outline .= "-" x ($left - $cx);
		print $outline;
		print "\r";
		$ftp_hdl->put($prefix . $file);
	}
	$ftp_hdl->quit();
}

#####
## Local-Copy
#####


foreach $host (@winhosts) {
	#print $host . "\n";
	foreach $file (@files) {
		$reached ++;
		$outline = (split (/\./, $host))[0] . ":" . $file . " ";
		$left = 79 - length($outline);
		$cx = int ((($left + 0.0) / $nof) * $reached);
		$outline .= "x" x $cx;
		$outline .= "-" x ($left - $cx);
		print $outline;
		print "\r";
		copy ($prefix . $file, "\\\\" . $host . "\\D\\SAP_DB\\TESTDB");
	}
}

print $nof;

