/* ####################################################
   tinysudo.c
   2002-10-29 V0.1 by d038447
   (c) SAP AG
   
   A small (not standard-compilant) sudo-implementaiotion.
   Created for calling SAP DB / liveCache installation-programms
   
   #################################################### */

#define CONFPATH "/etc/tinysudo"
#define BUFSIZE  1024

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>

int main(int argc, const char ** argv) {
	char linebuf[BUFSIZE];
	int i, strsize, rv;
	struct stat confstat;
	FILE * conffile;	
	
	if (argc == 1) {
		fprintf(stderr, "Usage:\n%s command arguments\n", argv[0]);
		exit(1);
	}

	if (stat(CONFPATH, &confstat) != 0) {
		perror("Error in stating " CONFPATH);
		exit(1);
	}
	
	if ((confstat.st_uid != 0) /*|| (confstat.st_mode != S_IRUSR)*/ ) {
		fputs(CONFPATH " has wrong permissions for Access.\nOnly read-access for user root is accepted.\n", stderr);
		exit(1);
	}

	if (setuid(0) != 0) {
		perror("Could not change to root");
		exit(1);
	}
	
	if ((conffile = fopen(CONFPATH, "r")) == (FILE *) NULL) {
		perror("Could not open " CONFPATH);
		exit(1);
	}
	
	while (!feof(conffile)) {
		if (fgets(linebuf, BUFSIZE, conffile) == (char *) NULL) {
			if (!feof(conffile)) {
				fputs("Error while reading form " CONFPATH "\n", stderr);
				exit(1);
			}
		}
		
		strsize = strlen(linebuf);
		strsize--;
		if (strsize <= 1) continue;
		if (linebuf[strsize] == '\n') linebuf[strsize] = '\0';
		if (strstr(argv[1], linebuf) == argv[1]) {
			linebuf[0] = '\0';
			strsize = 1;
			for(i = 1; i < argc; i++) {
				strsize += (strlen(argv[i]) + 3);
				if (strsize > BUFSIZE) {
					fputs("Buffer too small!\nAborting.\n", stderr);
					exit(1);
				}
				strcat(linebuf, "\"");
				strcat(linebuf, argv[i]);
				strcat(linebuf, "\" ");
			}
			rv = system(linebuf);
			exit(WEXITSTATUS(rv));
		}
	}
	
	fputs("The directory has not been found!\n", stderr);
	return 1;
}
