#!/devtool/local/bin/perl

use Cwd;

BEGIN {
	if ($^O =~ /win32/i)
	{
		my $testdrive = "d:";
		if (( (caller())[1] =~ /^(.:)/ ) || (cwd() =~ /^(.:)/)) { 
			$testdrive = $1;	
		}
		else { 
			print ("Waring: Can't determine test drive from callers path\n"); 
			print ("        set testdrive to $testdrive (default)\n"); 
		}
		push @INC, "$testdrive\\devtool\\bin";
		push @INC, "$testdrive\\devtool\\lib";
		push @INC, "$testdrive\\devtool\\lib\\perl5";
		push @INC, "$testdrive\\devtool\\lib\\Perl";

		push @INC, (	"$testdrive\\SAP_DB\TESTDB", 
				"$testdrive\\SAP_DB\\TESTDB\\lib");
	} else {
		unshift @INC, (	"/devtool/TOOL/tool/lib/perl5", 
				"/devtool/TOOL/tool/lib/Perl", 
				"/devtool/TOOL/tool/bin", 
				"/SAP_DB/TESTDB", 
				"/SAP_DB/TESTDB/lib");
	}
}

use Sys::Hostname;
use testdb;
use QAConnect;
use Getopt::Long;

$| = 1;

print "\n\nbenchmark v0.1a (c)2004, SAP AG\n\n";

my %opts;

unless (GetOptions(\%opts, 'host=s', 'weekday=i', 'hour=i', 'rel_filter=s', 'debug'))
{
	print <<HELP_END;
Usage:	chr_benchmark	[-host <host>] [-weekday <number>] [-hour <number>]
			[-rel_filter <reg-ex>]

Where:		-host <host>		sets an alternative host name
		-weekday <number>	sets (pretends) the day of week
		-hour <number>		pretends a special hour

HELP_END
	exit(1);
}

$opts{'host'} 		= ($opts{'host'} 	? $opts{'host'} 	: hostname());
$opts{'weekday'} 	= ($opts{'weekday'}	? $opts{'weekday'}	: (localtime (time))[6]);
$opts{'hour'}		= ($opts{'hour'} 	? $opts{'hour'} 	: (localtime (time))[2]);

&dbgout("select a.*, c.desctext AS QASTATUS, d.hod  from BENCHMARK_SCHED a, servers b, qastatus c, timeranges d WHERE a.idserver = b.id AND b.host = '$opts{'host'}' AND a.idqastatus = c.id AND a.idtimerange = d.id  AND  a.dow = $opts{'weekday'} AND d.hod = $opts{'hour'} ORDER BY a.version DESC, a.idqastatus DESC");

($rc, $href) 	= QAConnect::httpsql_request("QADB_HTTPSQL", "select a.*, c.desctext AS QASTATUS, d.hod  from BENCHMARK_SCHED a, servers b, qastatus c, timeranges d WHERE a.idserver = b.id AND b.host = '$opts{'host'}' AND a.idqastatus = c.id AND a.idtimerange = d.id  AND  a.dow = $opts{'weekday'} AND d.hod = $opts{'hour'} ORDER BY a.version DESC, a.idqastatus DESC", 1);

my $inst_path		= $ENV{'PATH'};
my %priolist;
my @tdl;
my @tol; # testdb-object-list
my $i_tol; # current length of tol.
my $cur_rel;
if ($rc)
{
	my $pre_version    = undef;
	my $pre_idqastatus = undef;
	
	foreach $act_row (@{$href->{'Rows'}->{'Row'}}) {
		if ((int($act_row->{'VERSION'})    != $pre_version) or
		    (int($act_row->{'IDQASTATUS'}) != $pre_idqastatus)) {
			$pre_version    = $act_row->{'VERSION'};
			$pre_idqastatus = $act_row->{'IDQASTATUS'};
			&dbgout("VERSION = $pre_version\nQASTATUS = $act_row->{'QASTATUS'}");
			$i_tol = push (@tol, testdb->new({'version' => $act_row->{'VERSION'}, 'status' => $act_row->{'QASTATUS'}}, {'SESSION_TYPE' => 'BEN'}));
			$i_tol--;
			$tol[$i_tol]->preClean();
			$tol[$i_tol]->installLC();
			$tol[$i_tol]->installTF();
		}
		push(@tdl, [$act_row->{'PRIO'}, $i_tol, $act_row->{'SEQNAME'}]);
	}
	@tdl = sort {$$b[0] <=> $$a[0]} @tdl;
	
	foreach $ent (@tdl) {
		$tol[$$ent[1]]->run_single_test($$ent[2]);
		$tol[$$ent[1]]->{'qah'}->set_sessiontype('BEN');
	}
}


print "All done!\n\n";

exit(0);

sub dbgout
{
	my $str = shift;
	print ">>DEBUG: $str\n" if ($opts{'debug'});
}



exit(0);
