#!/usr/bin/perl
# @(#) set_good_changelist.pl	25-01-2005	Ulrich Jansen
#
# Bereitstellen eines Parameter-Strings fr die Pre-Tests.
#
#    ========== licence begin  GPL
#    Copyright (C) 2001 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end
#

BEGIN {
	if ($^O !~ /win32/i) {
		unshift @INC, ("/devtool/TOOL/tool/lib/perl5", "/devtool/TOOL/tool/lib/Perl", "/devtool/TOOL/tool/bin", "/SAP_DB/TESTDB");
	}
	unshift @INC, ($^O =~ /win32/i ? "\\SAP_DB\\TESTDB\\lib" : "/SAP_DB/TESTDB/lib");
}

use strict;

use Net::HTTP;
use HTTP::Status;
use Getopt::Long;
use QAConnect;

$| = 1;
my $makeid;

print "\nset_good_changelist 1.00a (c)2005, SAP AG\n\n";

GetOptions('makeid=i' => \$makeid);

# Local Variables:
my $DEBUG = 1;

QAConnect::setdbg($DEBUG);

# Read make entry from makes table.
my ($rc, $href)     = QAConnect::httpsql_request("QADB_HTTPSQL", "select VERSION, IDPLATFORM, CHANGELIST from TESTER.MAKES where ID=$makeid", 1); 
(ref($href) and $href->{'Rows'}->{'Row'}[0]->{'CHANGELIST'}) or QAConnect::throw_error("UNKNOWN MAKEID", "The make ID given has no entry in MAKES table!", 1);

# Copy href data to local variables:
my $platform_id     = $href->{'Rows'}->{'Row'}[0]->{'IDPLATFORM'};
my $release 		= $href->{'Rows'}->{'Row'}[0]->{'VERSION'};
my $changelist 		= $href->{'Rows'}->{'Row'}[0]->{'CHANGELIST'};
QAConnect::dbgout("Make ID     : $makeid");
QAConnect::dbgout("Platform ID : $platform_id");
QAConnect::dbgout("Release     : $release");
QAConnect::dbgout("Changelist  : $changelist");
my $do_enter 		= 0;
my $maybe 			= 0;

# Now let's check, if there is a pretest entry:
($rc, $href)        = QAConnect::httpsql_request("QADB_HTTPSQL", "SELECT DRIVERTESTS, DRIVERERRORS, DRIVERTESTSPLANNED FROM JAVATESTINFO WHERE MAKEKEY=$makeid AND TESTSEQUENCE='pretest_lc.seq' ORDER BY DRIVERSTARTED DESC", 1);
if (ref($href) and ($href->{'Rows'}->{'Row'}[0]->{'DRIVERTESTSPLANNED'} ne "")) {
	#OK, we found an entry!
	QAConnect::dbgout("Tests planned  : $href->{'Rows'}->{'Row'}[0]->{'DRIVERTESTSPLANNED'}");
	QAConnect::dbgout("Tests executed : $href->{'Rows'}->{'Row'}[0]->{'DRIVERTESTS'}");
	QAConnect::dbgout("Tests errors   : $href->{'Rows'}->{'Row'}[0]->{'DRIVERERRORS'}");
	if (($href->{'Rows'}->{'Row'}[0]->{'DRIVERERRORS'} == 0) && ($href->{'Rows'}->{'Row'}[0]->{'DRIVERTESTS'} == $href->{'Rows'}->{'Row'}[0]->{'DRIVERTESTSPLANNED'})) {
		$do_enter = 1;
	}
} else {
	QAConnect::dbgout("NOTE: Could not find any pretest entries in database.");
	$do_enter = 1;
	$maybe = 1;
}

if ($do_enter) {
	QAConnect::dbgout("Pretest was " . ($maybe ? "maybe " : "") . "ok.");
	($rc, $href) = QAConnect::httpsql_request("QADB_HTTPSQL", "SELECT RELVER, GOOD_ID, MAYBEGOOD_ID, GOOD_CL, MAYBEGOOD_CL FROM LAST_GOOD_MAKE WHERE RELVER='$release' AND IDPLATFORM=$platform_id", 0);
	if (ref($href) and ($href->{'Rows'}->{'Row'}[0]->{'RELVER'} ne "")) {
		# We have already an entry...so let's update it.
		if ($maybe) {
			if ($href->{'Rows'}->{'Row'}[0]->{'MAYBEGOOD_ID'} > $makeid) {
				QAConnect::dbgout("Warning! Make ID already stored ($href->{'Rows'}->{'Row'}[0]->{'MAYBEGOOD_ID'}) is newer than actual one ($makeid)!");
				exit(0);
			}
			($rc, $href) = QAConnect::httpsql_request("QADB_HTTPSQL", "UPDATE LAST_GOOD_MAKE SET MAYBEGOOD_ID=$makeid, MAYBEGOOD_CL=$changelist WHERE RELVER='$release' AND IDPLATFORM=$platform_id", 0);
		} else {
			if ($href->{'Rows'}->{'Row'}[0]->{'GOOD_ID'} > $makeid) {
				QAConnect::dbgout("Warning! Make ID already stored ($href->{'Rows'}->{'Row'}[0]->{'GOOD_ID'}) is newer than actual one ($makeid)!");
				exit(0);
			} elsif ($href->{'Rows'}->{'Row'}[0]->{'MAYBEGOOD_ID'} > $makeid) {
				($rc, $href) = QAConnect::httpsql_request("QADB_HTTPSQL", "UPDATE LAST_GOOD_MAKE SET GOOD_ID=$makeid, GOOD_CL=$changelist WHERE RELVER='$release' AND IDPLATFORM=$platform_id", 0);
			} else {
				($rc, $href) = QAConnect::httpsql_request("QADB_HTTPSQL", "UPDATE LAST_GOOD_MAKE SET GOOD_ID=$makeid, MAYBEGOOD_ID=0, GOOD_CL=$changelist, MAYBEGOOD_CL=0 WHERE RELVER='$release' AND IDPLATFORM=$platform_id", 0);
			}
		}
		exit(1) unless ($rc);
	} else {
		# This release is new...
		if ($maybe) {
			($rc, $href) = QAConnect::httpsql_request("QADB_HTTPSQL", "INSERT INTO LAST_GOOD_MAKE VALUES ($release, $platform_id, 0, $makeid, 0, $changelist)", 0);
		} else {
			($rc, $href) = QAConnect::httpsql_request("QADB_HTTPSQL", "INSERT INTO LAST_GOOD_MAKE VALUES ($release, $platform_id, $makeid, $makeid, $changelist, $changelist)", 0);
		}
		exit(1) unless ($rc);
	}
	

} else {
	QAConnect::dbgout("Pretest was NOT ok!");
}
exit(0);