#! /usr/bin/perl
#
# $Header: //sapdb/TOOLSRC/develop/sys/src/BuildPackage/WinLink.pm#2 $
# $DateTime: 2002/06/10 14:15:26 $
# $Change: 22128 $
#
# Desc:
#
#    ========== licence begin LGPL
#    Copyright (C) 2002 SAP AG
#
#    This library is free software; you can redistribute it and/or
#    modify it under the terms of the GNU Lesser General Public
#    License as published by the Free Software Foundation; either
#    version 2.1 of the License, or (at your option) any later version.
#
#    This library is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#    Lesser General Public License for more details.
#
#    You should have received a copy of the GNU Lesser General Public
#    License along with this library; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#    ========== licence end
#

#
# A few basics right at the beginning:
BEGIN
{
	if ($^O =~ /win32/i)
	{
		my $testdrive = "d:";
		if ((caller())[1] =~ /^(.:)/) { 
			$testdrive = $1;	
		}
		push @INC, "$testdrive\\devtool\\bin";
		push @INC, "$testdrive\\devtool\\lib";
		push @INC, "$testdrive\\devtool\\lib\\perl5";
		push @INC, "$testdrive\\devtool\\lib\\Perl";
		push @INC, "$testdrive\\SAP_DB\\TESTDB";
		push @INC, "$testdrive\\SAP_DB\\TESTDB\\lib";
		chdir("$testdrive\\SAP_DB\\TESTDB");
	}
	else
	{
		push @INC, ("/devtool/local/bin");
		push @INC, ("/devtool/local/lib");
		push @INC, ("/devtool/local/Perl");
		push @INC, ("/devtool/local/perl5");
		push @INC, ("/SAP_DB/TESTDB");
		push @INC, ("/SAP_DB/TESTDB/lib");
        push @INC, ("/devtool/TOOL/tool/bin");
        push @INC, ("/devtool/TOOL/tool/lib/perl5");
		chdir("/SAP_DB/TESTDB");
	}
}

my %ienv = %ENV;
close STDERR;
open STDERR, ">&STDOUT";
select STDOUT;

select (STDERR);
$| = 1;
select (STDOUT);
$| = 1;

$| = 1; # Nur zur Sicherheit, damit das (unntige) Buffering ausgeschaltet wird.

use Sys::Hostname;
use QAConnect;

if ($^O =~ /MSWin32/i) {
    require File::DosGlob ;
    import  File::DosGlob 'glob';
    require WinLink;
    import  WinLink;
    require Win32::TieRegistry;
    import  Win32::TieRegistry;
    require Win32::Process;
    import  Win32::Process;
   	if (!(hostname() =~ /loanw/i)) {
	    system("NET USE L: \\\\pwdfm017\\LC_POOL ");
	} else {
		system("NET USE l: \\\\production\\MaxDB\\LC_POOL\\ntamd64");
	}
}

require testdb;
import testdb;

my %options = ();

use Getopt::Long;
use IniFile;

if (! &GetOptions(  \%options,
            'h|help|?',
            'package=s@',          
	    'packid=i@',
            'testonly',
            'verbose|V',
            'test_profile=s',
            'lowtrack',
	    'installonly',
	    'preclean',
	    'postclean',
		'no_objstat',
            'xterm',
            'testname=s',
            'testpackages=s',
            'delay=i',
            'cmd=s',
            'testgroups|nog=i',
            'sync_low',
            'complete',
            'cpc=s',
			'components=s'
            )) {
    print("Run testdb.pl -h for help");
    exit(1);
}

if (($options{'h'})) #||(!$options{'version'}) || (!$options{'status'})) {
{
    print <<EOF;

    Usage:
testdb.pl -package <VERSION><STATUS> [-verbose] [-xterm] [-complete]
          [ -verbose ] [ -noinstall ] [-cpc <VERSION><STATUS>] 
          [ -testpackages <TESTPACKAGES> ]
          [ -test_profile <PROFILENAME> ]
          [ -preclean ] [ -postclean ] [-components <INST_COMPONENTS>]

where <VERSION> can either be
    7403    (This can be a possible exception on AIX 4)
or
    7402

and <STATUS> can be
    DEV
or
    COR
or
    RAMP

<PROFILENAME> can be
    workday (the default)
or
    weekend
    
<TESTPACKAGES> 
	testpackages to install for testframe separates by ","
	current packages:
	   cpc
	   sut
	   tp2
	   mut
	   odbc
	   sqldbc

-verbose      tells you a bit more of what the script is doing.
-xterm        will open an xterm-Windows with the right environment.
              Please make sure that your DISPLAY-Varible is set correctly.
-testname     Will perform a single test without any instalation. You
              need to provide the dbname parameter with this.
-testonly     Will only perform the testing without installing any software
-installonly  Will only perform the installation of the DB- and Testsoftware.
-complete     will start complete installation on "empty" system
-cpc          will install another precompiler version (only one package allowed)
-preclean	  Removes all previous installations at start time.
-postclean	  Does a complete post cleanup at the end.
-components   Will only install components listed in INST_COMPONENTS.


EOF
exit(0)
}

if ((defined ($options{'testgroups'})) and (!(defined $options {'delay'}))) {
    print "Error in option-Mix: you gave me a 'testgroups'-parameter but no 'delay'-parameter.Exiting\n";
    exit(1);
}

if ($options{'test_profile'} ne "weekend") {
        $options{'test_profile'} = "workday";
}

my @testq;

########
# Anayzing arguments for tests to be performed.
########
my $init_path = $ENV{'PATH'};
if ($options{'cpc'} && (scalar(@{$options{'package'}}) > 1)) {
	testdb::throw_err("testdb.pl allowed only one package with another precompiler version :-((");
}

#
# Config?
#

my $confpath = "";
my $etc_hash = "";

foreach $x   (@{$options{'package'}}) {
	$ENV{'PATH'} = $init_path;
	if ($x =~ /^\d{4}(DEV|COR|RAMP|HOT)$/i) {

        $confpath = ($^O =~ /win32/i) ? ((-d "d:/SAP_DB") ? "d:/SAP_DB" : "c:/SAP_DB") : "/SAP_DB";
        mkdir ("$confpath/$x", 0777) unless (-d "$confpath/$x");
        mkdir ("$confpath/$x/db", 0777) unless (-d "$confpath/$x/db");
        mkdir ("$confpath/$x/etc", 0777) unless (-d "$confpath/$x/etc");
        mkdir ("$confpath/$x/test", 0777) unless (-d "$confpath/$x/test");
        mkdir ("$confpath/$x/tmp", 0777) unless (-d "$confpath/$x/tmp");
        $confpath .= "/$x/etc/db-keys";

		if (-e $confpath) {
			$etc_hash = IniFile::load($confpath);
			print "DBG: $etc_hash->{'IDSESSION'}\n";
		}
		
		if (defined ($options{'cpc'})){
			push(@testq, testdb->new({'version' => substr($x, 0, 4), 'status' => substr($x, 4, 10), 'profile' => $options{'test_profile'}, 'pcversion' => $options{'cpc'}, 'no_objstat' => ($options{'no_objstat'} ? 1 : 0), 'instcomponents' => ($options{'components'} ? $options{'components'} : 'all')}, ($etc_hash->{'IDSESSION'}) ? {'ID' => $etc_hash->{'IDSESSION'}} : {'SESSION_TYPE' => 'TBS'}));
		} else {
			push(@testq, testdb->new({'version' => substr($x, 0, 4), 'status' => substr($x, 4, 10), 'profile' => $options{'test_profile'}, 'no_objstat' => ($options{'no_objstat'} ? 1 : 0), 'instcomponents' => ($options{'components'} ? $options{'components'} : 'all')}, ($etc_hash->{'IDSESSION'}) ? {'ID' => $etc_hash->{'IDSESSION'}} : {'SESSION_TYPE' => 'TBS'}));
		}
		
		if ($testq[-1]->{error_code}) {
		    testdb::throw_err ($testq[-1]->{error_text});
		    pop(@testq);
		}
		print substr($x, 0, 4) . " " . substr($x, 4, 10) . "\n";
	} else {
		testdb::throw_err("testdb.pl got wrong parameters :-((");
	}
}

$etc_hash = undef;

foreach $x (@{$options{'packid'}}) {
	    $ENV{'PATH'} = $init_path;
        my ($rc, $href) = QAConnect::httpsql_request("QADB_HTTPSQL", "select VERSION, QASTATUS from MONITOR_MAKES where ID=$x", 0);
        my $relver = ($rc && $href->{'Rows'}->{'Row'}[0]->{'VERSION'}) ? $href->{'Rows'}->{'Row'}[0]->{'VERSION'} . uc($href->{'Rows'}->{'Row'}[0]->{'QASTATUS'}) : $x;
        unless ($relver == $x) { # Note: If relver == x, then reading DB-Version from QADB failed!! --> Reading config makes no sense then!
            $confpath = ($^O =~ /win32/i) ? ((-d "d:/SAP_DB") ? "d:/SAP_DB" : "c:/SAP_DB") : "/SAP_DB";
            mkdir ("$confpath/$x", 0777) unless (-d "$confpath/$x");
            mkdir ("$confpath/$x/db", 0777) unless (-d "$confpath/$x/db");
            mkdir ("$confpath/$x/etc", 0777) unless (-d "$confpath/$x/etc");
            mkdir ("$confpath/$x/test", 0777) unless (-d "$confpath/$x/test");
            mkdir ("$confpath/$x/tmp", 0777) unless (-d "$confpath/$x/tmp");
            $confpath .= "/$x/etc/db-keys";
            if (-e $confpath) {
                $etc_hash = IniFile::load($confpath);
                print "DBG: $etc_hash->{'IDSESSION'}\n";
            }
        }
        push(@testq, testdb->new({'ID' => $x, 'profile' => $options{'test_profile'}, 'no_objstat' => ($options{'no_objstat'} ? 1 : 0), 'instcomponents' => ($options{'components'} ? $options{'components'} : 'all')}, ($etc_hash->{'IDSESSION'}) ? {'ID' => $etc_hash->{'IDSESSION'}} : {'SESSION_TYPE' => 'TBS'}));
        if ($testq[-1]->{error_code}) {
            testdb::throw_err ($testq[-1]->{error_text});
            pop(@testq);
        }
}	

if (defined ($options{'preclean'}))
{
	$x = $testq[0];
	$x->removeAll();
}

if (defined ($options{'testname'})) {
    $x = $testq[0];
    my @testnames = split ',', $options{'testname'};
	foreach (@testnames)
	{
		if ($_ =~ /pretest/) {
			$x->{'qah'}->set_sessiontype('PRE');
		}
    	$x->run_single_test($_);	  
    }
    CleanExit(0);
}


if (defined ($options{'xterm'})) {
    $x = $testq[0];
    $x->term();
    exit(0);
}

if (defined ($options{'cmd'})) {
    $x = $testq[0];
    $x->cmd($options{'cmd'});
    CleanExit(0);
}

if (defined($options{'testonly'})) {
    foreach $x (@testq) {
        $x->runTF();
    }

}

elsif (defined($options{'lowtrack'})) {

    foreach $x (@testq) {

        if ($options{'sync_low'})
        {
            my $s_lock = Sema_Lock($x->{'globtemp'} . $x->{'delimit'} . "sut.lock");
            $x->run_lowtrack();
            Sema_Unlock($s_lock) if ($s_lock);
        }
        else
        {
            $x->run_lowtrack();
        }
    }
}
else {
    my $upcount = 0;
    foreach $x (@testq) {
        if ($options{'complete'})	{

        	$x->installLCComplete();
		}
		else {
			$x->preClean();
			$x->installLC();
		}
		if ($options{'testpackages'}) {
			$x->installTF({'components' => $options{'testpackages'}});
		}
		else {
			$x->installTF();
		}
        if (defined ($options{'testname'}) && defined ($options{'complete'}) ) {
        	my @testnames = split ',', $options{'testname'};
        	foreach (@testnames)
        	{
		    	$x->run_single_test($_);	  
		    }
		    $x->removeAll() if (defined ($options{'postclean'}));
		    exit (0);
		}		
    }
    
    if (! $options{'installonly'}) {
	    if ($^O =~ /MSWin32/i) {
	        my @process_id;
	        foreach $x (@testq) {
		print "\nSetting session-type..";
		$x->{'qah'}->set_sessiontype('NIGHT');
		print "..OK\n";
	            sleep(30);
	            push(@process_id, "");
	            %ENV = %ienv;
	            print "perl D:\\SAP_DB\\TESTDB\\testdb.pl -test_profile $options{'test_profile'} -testonly " . ($options{'sync_low'} ? "-sync_low " : "") . "-packid " . $x->{'qah'}->{'ID'};
	            Win32::Process::Create($process_id[-1],
	                    "d:\\depot\\tools\\gen\\ntintel\\OpenSource\\perl\\5.6.1\\bin\\perl.exe",
	                    "perl D:\\SAP_DB\\TESTDB\\testdb.pl -test_profile $options{'test_profile'} -testonly " . ($options{'sync_low'} ? "-sync_low " : "") . "-packid " . $x->{'qah'}->{'ID'},
	                    0,
	                    NORMAL_PRIORITY_CLASS,
	                    "D:\\SAP_DB\\TESTDB") ||
	                    print("Error while trying to execute sub-perl:\n" . Win32::FormatMessage(Win32::GetLastError()));
	            push(@process_id, "");
	            sleep(70);
	
	            print "perl D:\\SAP_DB\\TESTDB\\testdb.pl -test_profile $options{'test_profile'} -lowtrack " . ($options{'sync_low'} ? "-sync_low " : "") . "-packid $x->{'qah'}->{'ID'}";
	            %ENV = %ienv;
	            Win32::Process::Create($process_id[-1],
	                    "d:\\depot\\tools\\gen\\ntintel\\OpenSource\\perl\\5.6.1\\bin\\perl.exe",
	                    "perl D:\\SAP_DB\\TESTDB\\testdb.pl -test_profile $options{'test_profile'} -lowtrack " . ($options{'sync_low'} ? "-sync_low " : "") . "-packid " . $x->{'qah'}->{'ID'},
	                    0,
	                    NORMAL_PRIORITY_CLASS,
	                    "D:\\SAP_DB\\TESTDB") ||
	                    print("Error while trying to execute sub-perl:\n" . Win32::FormatMessage(Win32::GetLastError()));
	
	            $upcount++;
	            print "Delay = $options{'delay'} \n";
	            print "Testgroups = $options{'testgroups'} \n";
	            if (defined ($options{'testgroups'}) ) {
	                if ($upcount == $options{'testgroups'}) {
	                    $upcount = 0;
	                    sleep ($options{'delay'});
	                }
	            }
	        }
	        foreach $x (@process_id) {
	            $x->Wait(INFINITE);
	        }
	    }
	    else {
	        my @process_id;
	        foreach $x (@testq) {
		print "\nSetting session-type..";
		$x->{'qah'}->set_sessiontype('NIGHT');
		print "..OK\n";
	            $rv = fork();
	
	            if ($rv) {
	                print "New process ID created;: $rv\n";
	                push(@process_id, $rv);
	            }
	            else {
	                $x->runTF();
	                CleanExit(0);
	            }
	            sleep (30);
	
	
	            $rv = fork();
	
	            if ($rv) {
	                push(@process_id, $rv);
	            }
	            else {
	
	                if ($options{'sync_low'})
	                {
	                    my $s_lock = Sema_Lock($x->{'globtemp'} . $x->{'delimit'} . "sut.lock");
	                    $x->run_lowtrack();
	                    Sema_Unlock($s_lock) if ($s_lock);
	                }
	                else
	                {
	                    $x->run_lowtrack();
	                }
	
	                CleanExit(0);
	            }
	            sleep (30);
	            $upcount++;
	            print "Delay = $options{'delay'} \n";
	            print "Testgroups = $options{'testgroups'} \n";
	            if (defined ($options{'testgroups'}) ) {
	                if ($upcount == $options{'testgroups'}) {
	                    $upcount = 0;
	                    sleep ($options{'delay'});
	                }
	            }
	        }
	        foreach $x (@process_id) {
	            waitpid ($x, 0);
	        }
	    }
	}
}

if (defined ($options{'postclean'}))
{
	$x = $testq[0];
	$x->removeAll();
}


sub Sema_Lock
{
    my $lockfile = shift;

    use Fcntl ':flock';
    use FileHandle;

    my $fh = new FileHandle (">$lockfile");
    if ($fh)
    {
        flock ($fh, LOCK_EX);
        print "INFO: Lock-file '$lockfile' locked by PID $$\n";
    }
    else
    {
        print STDERR "ERROR: Opening lock-file '$lockfile' failed!\n$!\n";
        return undef;
    }

    return $fh;
}

sub Sema_Unlock
{
    my $fh = shift;

    flock($fh, LOCK_UN);
    $fh->close;
    print "INFO: Lock-file unlocked by PID $$\n";
}


sub CleanExit
{
	my ($rc) = @_;

	if (defined ($options{'preclean'}))
	{
		my $y = $testq[0];
		$y->removeAll() if ($y);
	}
	
	exit($rc);
}

__END__

=head1 NAME

testdb.pl - Automated SAPDB/LiveCache-Tests in certain environments.

=head1 NOTE

This module is intended for internal use only.
Although it is free software, it won't be very usefull for the wide world

=head1 SYNOPSIS OF CREATING A NEW ENTRY

 use qadb;
 $qah =  qadb->new({'VERSION' => '7403',
    'BUILDPFX'   => '07',
    'QASTATUS'   => 'DEV',
    'CHANGELIST' => '12345'}) ;

 if ($qah->{error_code} != 0) {
    print "Error:\n$qah->{error_text}\n";
    return -1;
 }

=head1 SYNOPSIS OF LOADING A OLD ENTRY

 use qadb;
 $qah =  qadb->new({'ID' => 1234}) ;

 if ($qah->{error_code} != 0) {
    print "Error:\n$qah->{error_text}\n";
    return -1;
 }

=head1 SYNOPSIS OF LOADING AN ENTRY FOR TESTS

 use qadb;
 $qah = qadb->new_test({'PLATFORM' => 'alphaosf', 'VERSION' => 7404, 'QASTATUS' => 'DEV'});

 if ($qah->{error_code} != 0) {
    print "Error:\n$qah->{error_text}\n";
    return -1;
 }

=head1 DESCRIPTION

The C<qadb> class is a interface to the SAP-internal QA-System for SAP DB
and liveCache.

Each instance of C<qadb> represents a complete make in the sense of making
programs out of sourcecode. Aditionaly, it can carry informations about
the status of the programs made - test results for example.

A new instance of C<qadb> can be created in two ways:

=over 4

=item Creating a new entry

A couple of informations are required to create a new entry. Following
the perl standards, the constructor of the class is named C<new>. It
requires a hash-reference with the following entries:

  Name          Description                   Example value

 VERSION       4-digit Version              '7402'
 BUILDPFX      2-digit Build-prefix         '02'
 QASTATUS      The quality-status           'DEV'
 CHANGELIST    The CL-Number                '32456'

For AIX-Machines, the aditional "PLATFORM"-entry is required. This is
necssary becase the perl-interpreter does not make a difference between
AIX 4.x and AIX 5.x as we do it.

Currently, the followning values are accepted for PLATFORM:

    - sun_64
    - alphaosf
        - rs6000_51_64
    - rs6000_64
    - hp_64

Please keep in mind that a C<qadb>-instance normaly contains a variable
called C<ID> (you can access it with B<$qah-E<gt>{'ID'}>. This C<ID> identifies
a make-entry and will be needed later. So, I suggest to write this C<ID>
to the harddisk.

=item Loading a old entry

For loading a previously created entry, you need to call the contructor with
a hash-refernece, containing the ID generated by the inital creation of
the entry.

  Name          Description                   Example value

 ID            The ID taken from inital      5739
               creation

=back

=head1 METHODS

C<qadb> provides the following methods:

=over 4

=item $rv = update_columns({name1 => value1, ... , nameN => valueN});

Performs a update-statement on the main table. This should only be used
for updating IDOBJSTATUS, LCPOOLID, LC_OK and LCOK_TRANS.

It takes a hash-reference as arguement, filled with columnnames and the
corresponing values.

The "VARIABLES"-Section of this manual contains a complete description of all
fields.

Returns 0 on success.

=item $rv = write_log($log_text);

This adds a comment to the entry. The log-Text must not contain more than
1000 characters.

Returns 0 on success.

=item $rv = write_prot($prot_name, $prot  [, $info_text]);

Writes a protocoll to the WebDAV-server and creates a entry in the
appropriate table in the database.

It takes a protocolname, the protocol itself and a optional info text as
arguments.

If the info text is not provieded, the protocolname will be used for it.

Returns 0 on success.

=item $rv = unlock();

Releases the current DB-Connection, but don't forget about the Values.

This becomes necessary when the program forkes. See B<lock> for
further informations

Returns 0 on success.

=item $qah = lock();

Re-Creates the DB-Connection. This becomes necessary after performing
an B<unlock> in forking situations.

B<TAKE CARE:> this method will return a new instance. Overwrite the current one
with it. The following example will give you an idea how to do this:

   $qah->unlock();
   $pid = fork();
   $qah = $qah->lock();

   if ($pid) {
       #
       # go on here


=back

=head1 VARIABLES

C<qadb> contains the following variables. Variables corresponding with
fields in the database are marked with a X.

Please note that B<IDQASTATUS> and B<IDPLATFORM> differ from the
parameters B<QASTATUS> and B<PLATFORM> for the C<new>-constructor. The values stored in the
database are simple numeric representations of their alphanumeric
assignments. These assignments are stored in the tables B<PLATFORMS>
and B<QASTATUS>.

  Name         DB-Variable       Description

 ID                X            Identifies the complete build-process
 LCPOOLID          X            The number in the LC_POOL-directory
 VERSION           X            A four-digit version, eg. "7402"
 BUILDPFX          X            A two-digit buildprefix, eg. "05"
 IDPLATFORM        X            The numeric id of the platform
 IDQASTATUS        X            The numeric id if the QA-status
 IDOBJSTATUS       X            The numeric id of the make-status
 CHANGELIST        X            The Changelist-number
 TS                X            The timestamp of the last modification
 LCOK              X            Will be set when the tests are finished
                                successfully.
 LCOK_TRANS        X            Will be set after the LCOK-bit is
                                transfered into the appropriate structures
                in the filesystem.
 HISTCOUNT         X            Counts the number of changes in on these
                                informations. Will be updated automaticaly.
 error_code                     Conains the last error code set. After
                                successfull opterations it will be set to
                0.
 error_text                     Contains a human-readable description of
                                the last error.

=head1 ERROR HANDLING

Beneath the already introduced variables B<error_code> and B<error_text>
for error handling, a email will be sent in each case of a detected error.

The recipients of these Mails are currently hard-coded.

=head1 DBI INSTANCE

C<qadb> contains a ready-to-use DBI instance. It can be accessed by
B<$qah-E<gt>{dbh}>. Please use this with extreme care and use it
only if you can not avoid it.

The DBI documentation describes it in depth.

=head1 EXAMPLE

 use qadb;
 my $qah =  qadb->new({'VERSION' => '7403',
    'BUILDPFX'   => '07',
    'QASTATUS'   => 'DEV',
    'CHANGELIST' => '12345'}) ;

 if ($qah->{error_code} != 0) {
    print "Fehler:\n$qah->{error_text}\n";
    return -1;
 }

 if ($qah->update_columns({'LCPOOLID' => '012'}) != 0 ) {
     print "Error while update:\n$qah->{error_text}\n";
     return -1;
 }

 if ($qah->write_log("Hallo Welt, dies ist ein Test")) {
     print "Error while writing a log:\n$qah->{error_text}\n";
     return -1;
 }

 my $protocol = "";
 open (PROTOFILE, "/path/to/protocol") or die "Error reading protocol\n";

 while (<PROTOFILE>) {
     $protocol .= $_;
 }

 if ($qah->write_prot("make.log", $protocol, "This protocol contains the make-output.\n")) {
     print "Error while writing protocol make.log:\n$qah->{error_text}\n";
 }

=head1 COPYRIGHT

Copyright 2003 SAP AG

=cut

