#!/usr/bin/perl
#
#    ========== licence begin LGPL
#    Copyright (C) 2002 SAP AG
#
#    This library is free software; you can redistribute it and/or
#    modify it under the terms of the GNU Lesser General Public
#    License as published by the Free Software Foundation; either
#    version 2.1 of the License, or (at your option) any later version.
#
#    This library is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#    Lesser General Public License for more details.
#
#    You should have received a copy of the GNU Lesser General Public
#    License along with this library; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#    ========== licence end
#


use Config;
use Symbol;
use Cwd;

sub main {
	my %Makedefs = (
	'PERL_COREDIR' => get_coredir (),
	'PERL_XSUBPP' => get_xsubpp (),
	'PERL_TXT2INC' => get_txt2inc (),
	'PERL_CCFLAGS' => $Config{'ccflags'}." ".$Config{'cccdlflags'},
	'PERL_DEFS' => get_defs (),
	'PERL_INC' => "\$(PERL_COREDIR)",
	'PERL_INCLUDE' => "-I\$(PERL_COREDIR)",
	'PERL_CFLAGS' => "\$(PERL_CCFLAGS) \$(PERL_INCLUDE) \$(PERL_DEFS)",
	'PERL_DLD' => $Config{'ld'},
	'PERL_DLDFLAGS' => get_dldflags (),
	'PERL_LD' => $^O =~ /^mswin/i ? "link" : "\$(CC)",
	'PERL_LDFLAGS' => get_ldflags (),
	'PERL_DLEXT' => $Config{'dlext'},
	'PERL_OBJEXT' => $Config{'obj_ext'},
	'PERL_EXEEXT' => $Config{'exe_ext'},
	'PERL_EXTLIBS' => get_extlibs (),
	'PERL_LIBSMB' => get_libsmb ()
	);
	
	write_makefile (%Makedefs);
}

sub write_makefile {
	my %Makedefs = @_;
	my $fh = gensym ();
	open ($fh, "> Makefile");
	print ($fh
	"#\n".
	"# Makefile\n".
	"# this file is generated from Makefile.PL\n".
	"# do not edit this file, any changes will be lost\n".
	"#\n".
	"\n".	
	".SUFFIXES:\n".
	".SUFFIXES: .o .c .xs .h\n".
	"\n");

	while (my ($key, $value) = each %Makedefs) {
		next unless (defined $value);
		print ($fh $key." = ".$value."\n");
	}
	print $fh ("\n");

	write_body ($fh);
	close ($fh);
}

sub write_body {
	my $fh = shift;
	while (<DATA>) {
		chomp;
		if ($^O =~ /^aix/ && $_ =~ /-o (\w+)\.\$\(DLEXT\)/) {
			$_ .= " -bE:".$1.".exp";
		}
		if ($^O =~ /^mswin/i) {
			if ($_ =~ /-o (\w+)\.\$\(DLEXT\)/) {
				$_ .= " -def:".$1.".def";
				$_ =~ s/-o\s+/-out:/;
			} elsif ($_ =~ /-o \w+\$\(EXEEXT\)/) {
				$_ =~ s/-o\s+/-out:/;
			}
		}
		print ($fh $_."\n");
	}
}

sub get_dldflags {
	$^O =~ /aix/    ? get_dldflags_aix () :
	$^O =~ /mswin/i ? $Config{'lddlflags'}.
		" -libpath:\$(PERL_COREDIR) perl.lib" :
		$Config{'lddlflags'};
}

sub get_dldflags_aix {
	my @in = split (' ', $Config{'lddlflags'});
	my @out = ();
	foreach $_ (@in) {
		next if ($_ =~ /^-bE\:/);
		push @out, $_;
	}
	return (join " ", @out);
}

sub get_extlibs {
	$^O =~ /mswin/i   ? $Config{'libs'} :
	$^O =~ /^aix/     ? "-lm -lbsd" :
	$^O =~ /^dec_osf/ ? "-lm" :
	$^O =~ /^hpux/    ? "-lm" :
	$^O =~ /^linux/ && $Config{'archname'} =~ /^i\d86/ ? "-lm -lcrypt" :
	$^O =~ /^solaris/ ? "-lm -lsocket -lnsl" :
	"";	
}

sub get_libsmb {
	my $libsmb;
	my $cwd = getcwd ();
	my $ArchName = $Config{"archname"};
	my $OsName = $Config{"osname"};
	my $OsVers = $Config{"osvers"};

	if ($ArchName eq "aix") {
		# it seems that some peopole use a aix 4.3.1.0 maked perl
		$OsVers = "4.3.2.0"     if ($OsVers =~ /^4\.3\.\d\.\d/);
		$libsmb = $cwd."/arch/".$ArchName."-".$OsVers."/libsmb.ro";
	} elsif ($OsName eq "hpux") {
		# HPUX 11.00 lib has some problems with pathinfo2 use 10.20
		# $ext_lib = $cwd."/arch/".$OsName."-".$OsVers."/libsmb.ro";
		$OsVers = "10.20";
		$libsmb = $cwd."/arch/".$OsName."-".$OsVers."/libsmb.ro";
	} else {
		$libsmb = $cwd."/arch/".$ArchName."/libsmb.ro";
	}
	return $libsmb;
}

sub get_xsubpp {
	$^O =~ /^mswin/i  ? 
	"win32\\bin\\perl -Iwin32\\lib ".$Config{'privlibexp'}.
	"\\ExtUtils\\xsubpp" :
	"perl ".$Config{'privlibexp'}."/ExtUtils/xsubpp";
}

sub get_txt2inc {
	$^O =~ /^mswin/i  ? 
	"win32\\bin\\perl tool\\txt2inc" :
	"perl tool/txt2inc";
}

sub  get_coredir {
	$^O =~ /^mswin/i ? $Config{'archlibexp'}."\\CORE" :
	$Config{'archlibexp'}."/CORE"
}

sub get_ldflags {
	$^O =~ /mswin/i ? "-nodefaultlib -libpath:\$(PERL_COREDIR) perl.lib" :
	$^O =~ /hpux/ ? "+DA1.1 +DS2.0 -L\$(PERL_COREDIR) -lperl" :
	"-L\$(PERL_COREDIR) -lperl";
}

sub get_defs {
	my $defs = "-DHAS_BYTEORDER=".$Config{'byteorder'};

	my $ArchName = $Config{"archname"};
	if ($ArchName eq "aix") {
		$defs .= " -DAIX";
	} elsif ($ArchName =~ /i\d86-linux/) {
		$defs .= " -DI386 -DLINUX";
	} elsif ($ArchName eq "RM400") {
		$defs .= " -DRELINAT";
	}
	return ($defs);
}

main (@ARGV);

__DATA__
LD = $(PERL_LD)
TXT2INC=$(PERL_TXT2INC)
XSUBPP = $(PERL_XSUBPP)
CFLAGS = $(PERL_CFLAGS)
DLD = $(PERL_DLD)
DLD_FLAGS = $(PERL_DLDFLAGS)
LIBS = $(PERL_EXTLIBS)
LD_FLAGS = $(PERL_LDFLAGS)
DLEXT = $(PERL_DLEXT)
OBJEXT = $(PERL_OBJEXT)
EXEEXT = $(PERL_EXEEXT)
LIBSMB = $(PERL_LIBSMB)

.xs.c:
	$(XSUBPP) $*.xs > $*.c

.c$(OBJEXT):
	$(CC) -c $(CFLAGS) $<

target = extractcd$(EXEEXT)

main_OBJ = main$(OBJEXT)
smbglue_OBJ = smbglue$(OBJEXT)
strcasecmp_OBJ = strcasecmp$(OBJEXT)

SMB_OBJ = SMB$(OBJEXT)
ALL_SMB_OBJ = $(SMB_OBJ) $(smbglue_OBJ) $(strcasecmp_OBJ)
ALL_XS_OBJ = $(ALL_SMB_OBJ)
ALL_XS = SMB.$(DLEXT)

all: $(target) $(ALL_XS)

$(target): $(main_OBJ) $(ALL_XS_OBJ)
	$(LD) -o $(target) $(main_OBJ) $(ALL_XS_OBJ) $(LIBSMB) $(LIBS) $(LD_FLAGS)

script.h: script.pl
	$(TXT2INC) script.pl script.h sz_text

$(main_OBJ): main.c script.h
	$(CC) -c $(CFLAGS) main.c

SMB.$(DLEXT): $(ALL_SMB_OBJ)
	$(DLD) $(DLD_FLAGS) -o SMB.$(DLEXT) $(ALL_SMB_OBJ) $(LIBSMB) $(LIBS)

SMB$(OBJEXT): SMB.c
	$(CC) -c $(CFLAGS) SMB.c

SMB.c: SMB.xs
	$(XSUBPP) $*.xs > $*.c

clean:
	-rm $(ALL_XS)
	-rm $(main_OBJ) $(ALL_XS_OBJ)
	-rm script.h

mrpropper: clean
	-rm $(target)
	-rm Makefile

