# Standard library imports.
from os.path import abspath, dirname, join

# Enthought library imports.
import enthought.envisage

# The location of the Envisage package.
envisage = abspath(dirname(enthought.envisage.__file__))

# The plugin definitions required by the application.
PLUGIN_DEFINITIONS = [
    # Application plugins.
    join(envisage, 'core/tests/simple_plugin_definition.py'),
    join(envisage, 'core/tests/no_implementation_plugin_definition.py'),

    # Envisage plugins.
    join(envisage, 'core/core_plugin_definition.py'),
]

#### EOF ######################################################################
