""" The resource type for workspace resource. """


# Enthought library imports.
from enthought.envisage.resource import FolderResourceType
from enthought.traits.api import Instance

# Local imports.
from workspace import Workspace
from workspace_node_type import WorkspaceNodeType


class WorkspaceResourceType(FolderResourceType):
    """ The resource type for workspace resources. """

    #### 'ResourceType' interface #############################################

    # A trait that describes the kind of domain object that the type
    # represents.
    type = Instance(Workspace)

    ###########################################################################
    # 'ResourceType' interface.
    ###########################################################################

    #### Initializers #########################################################

    def _node_type_default(self):
        """ Initializes the node type. """

        return WorkspaceNodeType(resource_type=self)

#### EOF ######################################################################
