#-----------------------------------------------------------------------------
# Copyright (c) 2006 by Enthought, Inc.
# All rights reserved.
#
# This software is provided without warranty under the terms of the BSD
# license included in enthought/LICENSE.txt and may be redistributed only
# under the conditions described in the aforementioned license.  The license
# is also available online at http://www.enthought.com/licenses/BSD.txt
# Thanks for using Enthought open source!
#
# Author: Dave Peterson <dpeterson@enthought.com>
#
#-----------------------------------------------------------------------------

"""
A serializer to ensure action resources do not get serialized.

"""


# Enthought library imports.
from enthought.naming.object_serializer import ObjectSerializer

# Local imports
from action_resource import ActionResource


class ActionResourceSerializer(ObjectSerializer):
    """
    A serializer to ensure action resources do not get serialized.

    """

    ##########################################################################
    # 'ObjectSerializer' interface.
    ##########################################################################

    def can_load(self, path):
        """
        Return True if the serializer can load a file.

        Overridden to always return False.

        """

        return False


    def can_save(self, obj):
        """
        Return True if the serializer can save an object.

        Overriden to return True for ActionResources.

        """

        return isinstance(obj, ActionResource)


    def load(self, path):
        """
        Load an object from a file.

        Overridden to raise an exception if the load method gets called even
        though we indicate we can never load any files.

        """

        raise RuntimeError('This method should never be called.')


    def save(self, path, obj):
        """
        Save an object to a file.

        Overridden to avoid creating a file representation of the object.

        """

        return None


#### EOF #####################################################################

