""" The scripting plugin. """


# Enthought library imports.
from enthought.envisage import Plugin

# Local imports.
from scripting import ScriptingNamespace
from script_recorder import ScriptRecorder


class ScriptingPlugin(Plugin):
    """ The scripting plugin. """

    # The Ids of the services that we offer.
    ISCRIPTING = 'enthought.envisage.scripting.IScripting'
    ISCRIPT_RECORDER = 'enthought.envisage.scripting.IScriptRecorder'

    ###########################################################################
    # 'Plugin' interface.
    ###########################################################################

    def start(self, application):
        """ Starts the plugin. """

        # Register the services offered by the plugin.
        self._register_services(application)

        return

    ###########################################################################
    # 'Private' interface.
    ###########################################################################

    def _register_services(self, application):
        """ Registers the services offered by the plugin. """

        # Create and register a scripting service.
        scripting = ScriptingNamespace()
        self.register_service(self.ISCRIPTING, scripting)

        # Create and register the script recorder service.
        #
        # fixme: This is just for texting - it should be turned off until the
        # user explicitly requests it!
        script_recorder = ScriptRecorder(scripting=scripting, recording=True)
        self.register_service(self.ISCRIPT_RECORDER, script_recorder)

        

        # fixme: Hack for scripting!!!!!!!
        application.scripting = scripting

        return
        
#### EOF ######################################################################
