""" Adapts a Foo to a Bar. """


# Enthought library imports.
from enthought.traits.api import HasTraits, Instance

# Imports from 'misc' library which is two hierarchies up the directory
# containing this file.
import os, sys
current_dir = os.path.abspath(os.path.dirname(__file__))
dir_name = os.path.join(os.path.dirname(os.path.dirname(current_dir)), 'misc')
add_path = not dir_name in sys.path
if add_path:
    sys.path.append(dir_name)

from bar import Bar
from foo import Foo

if add_path:
    sys.path.pop(-1)

class FooBarAdapter(HasTraits):
    """ Adapts a Foo to a Bar. """

    # The object that we are adapting.
    adaptee = Instance(Foo)

    ###########################################################################
    # 'Bar' interface.
    ###########################################################################

    def bar(self):
        """ bar! """
        
        return self.adaptee.foo()

#### EOF ######################################################################
