""" An example view. """


# Standard library imports.
import os

# Enthought library imports.
from enthought.envisage.ui.view import View

# Local imports.
from file_system import FileSystem, Folder
from file_system_tree_view import file_system_tree_view


class ExampleView(View):
    """ An example view. """

    ###########################################################################
    # 'View' interface.
    ###########################################################################

    def _create_contents(self, parent):
        """ Create the toolkit-specific control that represents the view.

        'parent' is the toolkit-specific control that is the view's parent.

        """

        file_system = FileSystem(root=Folder(path=os.path.abspath(os.curdir)))

        ui = file_system.edit_traits(
            parent=parent, kind='subpanel', view=file_system_tree_view
        )

        return ui.control
    
#### EOF ######################################################################
