#!/usr/bin/python -E
import sys
from selinux import *
verbose = 0
errors=0
def untrans(trans, val):
    global errors, verbose
    (rc, raw) = selinux_trans_to_raw_context(trans)
    if raw != val:
        print "untrans: %s -> %s != %s FAILED" % (trans, raw, val)
        errors += 1
    else:
        if verbose:
            print "untrans: %s -> %s != %s SUCCESS" % (trans, raw, val)
        
def trans(raw, val):
    global errors, verbose
    (rc, trans) = selinux_raw_to_trans_context(raw)
    if trans != val:
        print "trans: %s -> %s != %s FAILED" % (raw,trans,  val)
        errors += 1
    else:
        if verbose:
            print "trans: %s -> %s != %s SUCCESS" % (raw, trans,  val)

if len(sys.argv) > 1 and sys.argv[1] == "-v":
    verbose = 1
    
trans("a:b:c:s0", "a:b:c:SystemLow")
trans("a:b:c:s2:c0", "a:b:c:Secret:A")
trans("a:b:c:s2:c1", "a:b:c:Secret:B")
trans("a:b:c:s2:c0,c1", "a:b:c:Secret:A,B")
trans("a:b:c:s15:c0.c1023", "a:b:c:SystemHigh")
trans("a:b:c:s2:c0-s2:c1", "a:b:c:Secret:A-Secret:B")
trans("a:b:c:s0-s15:c0.c1023", "a:b:c:SystemLow-SystemHigh")
trans("a:b:c:s0:c3", "a:b:c:s0:c3")
trans("a:b:c:s0:c3,c4", "a:b:c:s0:c3,c4")

untrans("a:b:c:SystemLow", "a:b:c:s0")
untrans("a:b:c:Secret:A", "a:b:c:s2:c0")
untrans("a:b:c:Secret:B", "a:b:c:s2:c1")
untrans("a:b:c:Secret:A,B", "a:b:c:s2:c0,c1")
untrans("a:b:c:SystemHigh", "a:b:c:s15:c0.c1023")
untrans("a:b:c:SystemLow-SystemHigh", "a:b:c:s0-s15:c0.c1023")
untrans("a:b:c:Wrong", "a:b:c:Wrong")
untrans("a:b:c:SystemLow:Wrong", "a:b:c:SystemLow:Wrong")
untrans("a:b:c:Secret:A-Secret:B", "a:b:c:s2:c0-s2:c1")
sys.exit(errors)


