/*
  CRF++ -- Yet Another CRF toolkit

  $Id: thread.h,v 1.5 2006/07/09 11:26:27 taku-ku Exp $;

  Copyright (C) 2005 Taku Kudo <taku@chasen.org>

*/
#ifndef _CRFPP_THREAD_H
#define _CRFPP_THREAD_H

#ifdef HAVE_PTHREAD_H
#include <pthread.h>
#else
#ifdef _WIN32
#include <windows.h>
#include <process.h>
#endif
#endif

#if defined HAVE_PTHREAD_H
#define MECAB_USE_THREAD 1
#endif

#if (defined  (_WIN32) && ! defined (__CYGWIN__))
#define MECAB_USE_THREAD 1
#endif

#define BEGINTHREAD(src, stack, func, arg, flag, id) \
     (HANDLE)_beginthreadex((void *)(src), (unsigned)(stack), \
           (unsigned (_stdcall *)(void *))(func), (void *)(arg), \
           (unsigned)(flag), (unsigned *)(id))

namespace MeCab {

  class thread {
  private:
#ifdef HAVE_PTHREAD_H
    pthread_t hnd;
#else
#ifdef _WIN32
    HANDLE  hnd;
#endif
#endif

  public:
    static void* wrapper(void *ptr) {
      thread *p = static_cast<thread *>(ptr);
      p->run();
      return 0;
    }

    virtual void run() {}

    void start() {
#ifdef HAVE_PTHREAD_H
      pthread_create(&hnd, 0, &thread::wrapper,
                     static_cast<void *>(this));

#else
#ifdef _WIN32
      DWORD id;
      hnd = BEGINTHREAD(0, 0, &thread::wrapper, this, 0, &id);
#endif
#endif
    }

    void join() {
#ifdef HAVE_PTHREAD_H
      pthread_join(hnd, 0);
#else
#ifdef _WIN32
      WaitForSingleObject(hnd, INFINITE);
      CloseHandle(hnd);
#endif
#endif
    }

    virtual ~thread() {};
  };
}
#endif
