/*
  MeCab -- Yet Another Part-of-Speech and Morphological Analyzer

  $Id: viterbi.h,v 1.11 2006/07/09 11:26:27 taku-ku Exp $;

  Copyright (C) 2001-2006 Taku Kudo <taku@chasen.org>
  Copyright (C) 2004-2006 Nippon Telegraph and Telephone Corporation

*/
#ifndef MECAB_VITERBI_H
#define MECAB_VITERBI_H

#include <vector>
#include "mecab.h"
#include "freelist.h"
#include "tokenizer.h"

namespace MeCab {

  class Param;
  class Connector;

  class Viterbi {
  private:
    Tokenizer* tokenizer_;
    Connector *connector_;
    Node*      eosNode_;
    Node*      bosNode_;
    char*      begin_;
    char*      end_;
    int        level_;
    double     theta_;
    double     Z_;
    bool copy_sentence_;
    bool partial_;
    scoped_ptr<FreeList<Path> > path_freelist_;
    std::vector<Node *> end_node_list_;
    std::vector<Node *> begin_node_list_;
    std::vector<char> sentence_;
    std::vector<char> constraint_buf_;

    bool  (Viterbi::*analyze_)(const char *,size_t);
    bool  (Viterbi::*connect_)(size_t, Node*);
    Node *(Viterbi::*buildLattice_)();

    whatlog what_;

    Node *lookup(size_t);

    bool connectNormal(size_t, Node*);
    bool connectWithAllPath(size_t, Node*);

    bool forwardbackward(const char*, size_t);
    bool viterbi(const char*, size_t);

    Node *filterNode(Node *, size_t);
    bool initConstraints(const char*&, size_t&);

    Node *buildBestLattice();
    Node *buildAllLattice();

    inline bool connect(size_t p, Node* n) {
      return (this->*connect_)(p, n);
    }

  public:
    void   clear();
    bool   open(Param&, Tokenizer*, Connector *);
    void   close();

    double Z() const  { return Z_; }

    Node *analyze(const char *str, size_t len);

    const char *what() { return what_.str(); }

    explicit Viterbi();
    virtual ~Viterbi();
  };
}
#endif
