/* status.c -- settings for saving  mailbox status
 *
 * Copyright(C) 2001-2002 Elisa Manara <e@entropika.net>
 * This code is released under the GPL License version 2 */

#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>
#include "melon.h"

static void update_save_status(GtkWidget *widget, gpointer user_data);
static void status_file_update (void);
static void set_status_file(char *status_file_path);

char *set_melon_dir(void);

gint set_save_status (GtkWidget *widget, gpointer data)
{
	GtkWidget *window;
	GtkWidget *vbox, *hbox1, *hbox2;
	GtkWidget *button, *label, *frame;

	/* window */
	window = gtk_window_new( GTK_WINDOW_DIALOG);
	gtk_window_set_position(GTK_WINDOW (window), GTK_WIN_POS_MOUSE);
	gtk_widget_set_usize( GTK_WIDGET (window), 300, 180);
	gtk_window_set_title(GTK_WINDOW (window), "Save Mailbox Status");
	gtk_widget_show(window);

	/* vbox */
	vbox = gtk_vbox_new( FALSE, 0 );
	gtk_container_add( GTK_CONTAINER( window ), vbox );
	gtk_widget_show( vbox );

	/* frame */
	frame = gtk_frame_new (NULL);
	/* label */
	label = gtk_label_new ("\nMelon can save the status of your mailboxes before quitting.\n" \
			       "Next time you'll launch it, Melon will be able to "\
			       "notify if new mails was received since it was "\
			       "off.\n\nShould Melon remember the mailboxes status?\n\n\n");

	gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_FILL);
	gtk_label_set_line_wrap (GTK_LABEL (label), TRUE);
	gtk_container_add (GTK_CONTAINER (frame), label);
	gtk_box_pack_start (GTK_BOX (vbox), frame, FALSE, FALSE, 5);

	gtk_widget_show(label);
	gtk_widget_show(frame);

	/* hbox1 */
	hbox1 = gtk_hbox_new( FALSE, 0 );
	//gtk_container_add( GTK_CONTAINER( vbox ), hbox1);
	gtk_box_pack_start (GTK_BOX ( vbox ), hbox1, TRUE, TRUE, 0);
	gtk_widget_show( hbox1 );

	/* hbox2 */
	hbox2 = gtk_hbox_new( FALSE, 0 );
	gtk_container_add( GTK_CONTAINER( vbox ), hbox2);
	gtk_widget_show( hbox2 );

	/* YES button */
	button = gtk_button_new_with_label ("Yes");
	/*
	gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
		GTK_SIGNAL_FUNC(update_save_status), "yes");
	*/
	gtk_signal_connect( GTK_OBJECT( button ), "clicked",
		GTK_SIGNAL_FUNC( update_save_status ), "yes");

	gtk_box_pack_start (GTK_BOX (hbox2), button, TRUE, TRUE, 0);
	gtk_widget_show (button);

	/* NO button */
	button = gtk_button_new_with_label ("No");
	/*
	gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
		GTK_SIGNAL_FUNC(update_save_status), "no");
	*/
	gtk_signal_connect( GTK_OBJECT( button ), "clicked",
		GTK_SIGNAL_FUNC( update_save_status ), "no");

	gtk_box_pack_start (GTK_BOX (hbox2), button, TRUE, TRUE, 0);
	gtk_widget_show (button);

	/* CLOSE button */
	button = gtk_button_new_with_label ("Close");
	gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
		GTK_SIGNAL_FUNC(gtk_widget_destroy),
		GTK_OBJECT (window));
	gtk_box_pack_start (GTK_BOX (hbox2), button, TRUE, TRUE, 0);
	gtk_widget_show (button);

	return 1;

}

void update_save_status (GtkWidget *widget, gpointer user_data)
{
	if (strcmp(user_data, "yes") == 0) {
		cfg_data.save_status = 1;
		dialog_message (" Melon will save mailbox status ");
	} else if (strcmp(user_data, "no") == 0) {
		dialog_message (" Melon will NOT save mailbox status ");
		cfg_data.save_status = 0;
	}

	config_update();

	return;
}

void save_status (void)
{
	if(cfg_data.save_status == 1) {
		status_file_update();
	}

	return;
}

void status_file_update (void)
{
	FILE *fp;
	int i;
	char status_file[MAX_PLEN];

	set_status_file(status_file);

	if((fp = fopen(status_file, "w")) == NULL) {
		char msg[1024];
		snprintf(msg, 1024, " Cannot open %s for writing ", status_file);
		dialog_message (msg);
		return;
	}

	for(i = 0; i < MAX_MBOX; i++)
	{
		if(cfg_data.mbox[i][0] == '\0')
			break;

		fprintf(fp,"%s %ld %ld\n", cfg_data.mbox[i], w_data.m_time[i], w_data.size[i]);
	}
	fclose(fp);
	return;
}

void set_status_file(char *status_file_path)
{
	char *melon_home_dir=set_melon_dir();

	snprintf(status_file_path, MAX_PLEN, "%s/%s", melon_home_dir, "melon.status");
	free(melon_home_dir);
}

int retrieve_mbox_status(char *mbox, int i) {

	FILE *fp;
	char buf[1024];
	char mbox_path[MAX_PLEN] = {'\0'};
	long old_time = 0;
	long old_size = 0;
	char status_file[MAX_PLEN];

	set_status_file(status_file);

	if((fp = fopen(status_file, "r")) == NULL)
		return 0;
	
	while(fgets(buf, 1024, fp) != NULL)
	{
		if(sscanf(buf, "%s %ld %ld\n", mbox_path, &old_time, &old_size) != 3)
			continue;
		if(strcmp(mbox_path, mbox) == 0) {
			w_data.m_time[i] = old_time;
			w_data.size[i] = old_size;
			return 1;
		}
	}
	fclose(fp);

	return 0;
}


	
