/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef BufrMetaData_H
#define BufrMetaData_H

#include <iostream>
#include <map>
#include <vector>
#include <list>
#include <assert.h>

#include <Metview.h>
#include "MvMessageMetaData.h"
#include "MvObs.h"

using namespace std;

class MvKeyProfile;

class BufrDataItem
{
public:
	BufrDataItem() {};

	const string& descriptor() {return descriptor_;}
	const string& name() {return name_;}
	const string& value() {return value_;}
	const string& unit() {return unit_;}

	void descriptor(string s) {descriptor_=s;}
	void name(string s) {name_=s;}
	void value(string s) {value_=s;}
	void unit(string s) {unit_=s;}


protected:
	string descriptor_;
	string name_;
	string value_;
	string unit_;
};


class BufrKey
{
public:
	BufrKey(string id, string n, string sn) : id_(id), name_(n), shortName_(sn) {};
	string& id() {return id_;};
	string& shortName() {return shortName_;};
	string& name() {return name_;};
	bool status() {return status_;};

	void shortName(string s) {shortName_=s;};
	void name(string s) {name_=s;};
	void status(bool b) {status_=b;};
	void addToCounter(string);
	map<string,int>& counter() {return counter_;};

protected:
	string id_;
	string name_;
	string shortName_;
	bool status_;
	map<string,int> counter_;
};

class BufrSectionItem
{
public:
	void name(string s) {name_=s;};
	string name() {return name_;};
	void value(string s) {value_=s;};
	string value() {return value_;};

protected:
	string name_;
	string value_;
};


class BufrSection
{
public:
 	BufrSection(string name) : name_(name) {};
	~BufrSection();
	string name() {return name_;};
	void setText(const string& c);
	string text() {return text_;};
	void addItem(BufrSectionItem* i) {item_.push_back(i);};
	const vector<BufrSectionItem*>& item() {return item_;};
	int itemNum() {return item_.size();}
	string itemValue(string);

protected:
	string name_;
	string text_;
	vector<BufrSectionItem*> item_;
};

class BufrSectionDump
{
public:
	BufrSectionDump() {};
	~BufrSectionDump();
	void clear();
	bool read(const string&, int);
	int  sectionNum() const {return section_.size();}
	const string& text() const {return text_;}
	const vector<BufrSection*>& section() {return section_;}

protected:
	vector<BufrSection*> section_;
	string text_;
};

class BufrDataDump
{
public:
	BufrDataDump() {};
	~BufrDataDump();
	void clear();
	void read(const string&, int,int);
	int  itemNum() const {return item_.size();}
	const string& text() const {return text_;}
	const vector<BufrDataItem*>& item() {return item_;}

protected:
	vector<BufrDataItem*> item_;
	string text_;
};

class BufrBitmapDump
{
public:
	BufrBitmapDump() : colNum_(0) {};
	~BufrBitmapDump();
	void clear();
	void read(const string&, int,int);
	int  itemNum() const {return item_.size();}
	const vector<vector<string> >& item() {return item_;}
	int colNum() {return colNum_;}

protected:
	int colNum_;
	vector<vector<string> > item_;

};


class BufrMetaData : public MvMessageMetaData
{
public:
	BufrMetaData();
	~BufrMetaData();
	void setFileName(string);
	int  subsetNum(int);
	void loadKeyProfile(MvKeyProfile *);
	void getKeyList(string,MvKeyProfile*);
	int getEstimatedMessageNum();
	bool useMessageSizeForProgressIndicator();

private:
	void readMessages(MvKeyProfile *);
	void readSection(BufrSection*,char*);
	string intToString(int);
	string formatDate(string, string, string);
	string formatTime(string, string, string);
	
	string tmpFile_;

	map<int,vector<BufrKey> > items_;
	static std::map<string,string> rdbKey_;
	MvKeyProfile *allKey_;
};


#endif
