/* Copyright 2005 Matt Flax <flatmax@ieee.org>
   This file is part of MFFM GTK wrapper class set

   MFFM GTK wrapper class set is free software; you can redistribute
   it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   MFFM GTK wrapper class set is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You have received a copy of the GNU General Public License
   along with MFFM GTK wrapper class set
 */
#ifndef PIXMAP_H_
#define PIXMAP_H_

#include <gtk/gtk.h>
#include <iomanip>

//#define DEBUG_P

/** Encapsulates the requirements of Gtk Pixmap
 */
class Pixmap {
  GtkWidget *gtkPixmap;
  GdkPixmap *gdkPixmap;

  static void expose_event(GtkWidget *widget, GdkEventExpose *event, gpointer data){
#ifdef DEBUG_P
    cout<<"Pixmap::Expose event"<<endl;
#endif
    GdkPixmap *pix=((Pixmap*)data)->getGdkPixmap();
    gdk_draw_pixmap(widget->window, widget->style->fg_gc[GTK_WIDGET_STATE (widget)], pix, event->area.x, event->area.y, event->area.x, event->area.y, event->area.width, event->area.height);
    //cout<<event->area.x <<'\t'<<event->area.y<< '\t'<<event->area.width<< '\t'<< event->area.height<<endl;
    //    GdkRectangle rect={0,0, event->area.width, event->area.height};
#ifdef DEBUG_P
    cout<<"Pixmap::Expose event exit"<<endl;
#endif
    }

  static void configure_event(GtkWidget *widget, GdkEventConfigure *event, gpointer data){
#ifdef DEBUG_P
    cout<<"Pixmap::Configure event"<<endl;
#endif
    GdkPixmap *pix=((Pixmap*)data)->getGdkPixmap();
      if (pix) gdk_pixmap_unref(pix);
      pix=gdk_pixmap_new(widget->window,widget->allocation.width, widget->allocation.height, -1);
      gdk_pixmap_ref(pix);
      ((Pixmap*)data)->setPixmap(pix);
  }
public:
  /// Constructor, requires the desired size
  Pixmap(int xSize, int ySize){
#ifdef DEBUG_P
    cout<<"Pixmap::Pixmap"<<endl;
#endif
    gdkPixmap=(GdkPixmap *)NULL;
    gtkPixmap=gtk_drawing_area_new();
    gtk_drawing_area_size (GTK_DRAWING_AREA(gtkPixmap), xSize, ySize);
    gtk_widget_show(gtkPixmap);
    gtk_signal_connect (GTK_OBJECT(gtkPixmap), "expose_event", GTK_SIGNAL_FUNC(expose_event), this);
    //    gtk_signal_connect (GTK_OBJECT(gtkPixmap),"configure_event", GTK_SIGNAL_FUNC(configure_event), this);

    GdkPixmap *pix=getGdkPixmap();
    if (pix) gdk_pixmap_unref(pix);
    pix=gdk_pixmap_new(NULL,xSize, ySize, gdk_visual_get_best_depth ());
    gdk_pixmap_ref(pix);
    setPixmap(pix);
  }

  ~Pixmap(){
#ifdef DEBUG_P
    cout<<"Pixmap::~Pixmap"<<endl;
#endif
    if (gdkPixmap) gdk_pixmap_unref(gdkPixmap);
  }

  /// Returns the Gtk window
  GtkWidget *getGtkPixmap(){return gtkPixmap;}
  /// Returns the Gdk Pixmap
  GdkPixmap *getGdkPixmap(){return gdkPixmap;}
  void setPixmap(GdkPixmap * pix){gdkPixmap=pix;}
};
#endif  //PIXMAP_H_
