/***************************************************************************
    copyright            : (C) 2002-2005 by Stefano Barbato
    email                : stefano@codesink.org

    $Id: codec_base.h,v 1.12 2006/03/12 12:04:36 tat Exp $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef _MIMETIC_CODEC_CODECBASE_H_
#define _MIMETIC_CODEC_CODECBASE_H_
namespace mimetic
{


struct buffered_codec_type_tag
{
};

struct unbuffered_codec_type_tag
{
};


/// Codecs base class
struct codec
{
    typedef unsigned char char_type;
    virtual ~codec() {}
    virtual const char* name() const = 0;

    /*! return the multiplier of the required (max) size of the output buffer 
     * when encoding */
    virtual double codeSizeMultiplier() const { return 1.0; }
};



/// Base class for unbuffered codecs
struct unbuffered_codec: public codec
{
    typedef unbuffered_codec_type_tag codec_type;
    template<typename OutIt>
    void flush(OutIt&)
    {
    }
};

/// Base class for buffered codecs
struct buffered_codec: public codec
{
    typedef buffered_codec_type_tag codec_type;
};


}

#endif

