/******************************************************************************
 *
 * Copyright (c) 1998,99 by Mindbright Technology AB, Stockholm, Sweden.
 *                 www.mindbright.se, info@mindbright.se
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 *****************************************************************************
 * $Author: mats $
 * $Date: 2000/04/07 07:14:55 $
 * $Name: rel1-2-1 $
 *****************************************************************************/
package mindbright.ssh;

import java.awt.*;
import java.awt.event.*;

import mindbright.util.AWTConvenience;

public class SSHSCPDialog {
    private final static String TXT_LOCAL_IS_SOURCE  = "Copy from local files/directories:";
    private final static String TXT_REMOTE_IS_TARGET = "To directory/file on server:";
    private final static String TXT_LOCAL_IS_TARGET  = "Copy to local directory/file:";
    private final static String TXT_REMOTE_IS_SOURCE = "From files/directories on server:";

    static Dialog scpDialog;
    static TextField localFile;
    static TextField remoteFile;
    static Label     localPos, remotePos;
    static Checkbox  cbRecursive, cbBackground;
    static FileDialog scpLocFD;
    static boolean toRemote;

    static SSHPropertyHandler propsHandler;
    static SSHInteractor      interactor;
    static Frame              parent;

    public static void show(String title, Frame p,
			    SSHPropertyHandler props,
			    SSHInteractor itor) {
	parent       = p;
	propsHandler = props;
	interactor   = itor;

	if(SSH.NETSCAPE_SECURITY_MODEL) {
	    try {
		netscape.security.PrivilegeManager.enablePrivilege("UniversalFileAccess");
	    } catch (netscape.security.ForbiddenTargetException e) {
		// !!!
	    }
	}

	if(scpDialog == null) {
	    scpDialog = new Dialog(parent, title, false);

	    GridBagLayout       grid  = new GridBagLayout();
	    GridBagConstraints  gridc = new GridBagConstraints();

	    scpLocFD = new FileDialog(parent, "MindTerm - Select file to copy", FileDialog.LOAD);
	    scpLocFD.setDirectory(propsHandler.getSSHHomeDir());

	    scpDialog.setLayout(grid);

	    gridc.fill      = GridBagConstraints.HORIZONTAL;
	    gridc.anchor    = GridBagConstraints.WEST;
	    gridc.gridwidth = 2;
	    gridc.gridy     = 0;

	    gridc.insets    = new Insets(8, 4, 4, 8);

	    localPos = new Label(TXT_LOCAL_IS_SOURCE);
	    grid.setConstraints(localPos, gridc);
	    scpDialog.add(localPos);

	    gridc.gridy = 1;
	    gridc.gridwidth = 3;

	    localFile = new TextField("", 38);
	    grid.setConstraints(localFile, gridc);
	    scpDialog.add(localFile);

	    localFile.setText(scpLocFD.getDirectory());

	    gridc.gridwidth = 1;
	    Button b = new Button("...");
	    b.addActionListener(new ActionListener() {
		public void actionPerformed(ActionEvent e) {
		    scpLocFD.setVisible(true);
		    if(scpLocFD.getFile() != null && scpLocFD.getFile().length() > 0) {
			String file = scpLocFD.getDirectory() + scpLocFD.getFile();
			if(file.indexOf(' ') != -1)
			    file = "\"" + file + "\"";
			localFile.setText(file);
		    }
		}
	    });
	    gridc.fill = GridBagConstraints.NONE;
	    grid.setConstraints(b, gridc);
	    scpDialog.add(b);

	    toRemote = true;
	    gridc.gridy = 2;
	    b = new Button("Change Direction");
	    b.addActionListener(new ActionListener() {
		public void actionPerformed(ActionEvent e) {
		    toRemote = !toRemote;
		    if(toRemote) {
			localPos.setText(TXT_LOCAL_IS_SOURCE);
			remotePos.setText(TXT_REMOTE_IS_TARGET);
		    } else {
			localPos.setText(TXT_LOCAL_IS_TARGET);
			remotePos.setText(TXT_REMOTE_IS_SOURCE);
		    }
		}
	    });
	    gridc.gridwidth = GridBagConstraints.REMAINDER;
	    gridc.fill = GridBagConstraints.NONE;
	    gridc.anchor = GridBagConstraints.CENTER;
	    grid.setConstraints(b, gridc);
	    scpDialog.add(b);

	    gridc.gridy = 3;
	    gridc.anchor    = GridBagConstraints.WEST;
	    gridc.gridwidth = 2;
	    gridc.fill = GridBagConstraints.HORIZONTAL;

	    remotePos = new Label(TXT_REMOTE_IS_TARGET);
	    grid.setConstraints(remotePos, gridc);
	    scpDialog.add(remotePos);

	    gridc.gridy = 4;
	    gridc.gridwidth = 3;

	    remoteFile = new TextField("", 38);
	    grid.setConstraints(remoteFile, gridc);
	    scpDialog.add(remoteFile);

	    /* !!! TODO make a remote file-browser (SSHClient -> cd, ls -l)
	       b = new Button("...");
	       b.addActionListener(new ActionListener() {
	       public void actionPerformed(ActionEvent e) {
	       }
	       });
	       gridc.fill = GridBagConstraints.NONE;
	       grid.setConstraints(b, gridc);
	       scpDialog.add(b);
	    */

	    gridc.gridy = 5;
	    gridc.gridwidth = 1;

	    cbRecursive = new Checkbox("Recursive copy", false);
	    grid.setConstraints(cbRecursive, gridc);
	    scpDialog.add(cbRecursive);

	    cbBackground = new Checkbox("Low priority", false);
	    grid.setConstraints(cbBackground, gridc);
	    scpDialog.add(cbBackground);

	    gridc.gridy = 6;
	    gridc.gridwidth = 2;

	    Button okBut, cancBut;
	    Panel bp = new Panel(new FlowLayout());
	    bp.add(okBut = new Button("Start Copy"));
	    okBut.addActionListener(new ActionListener() {
		public void actionPerformed(ActionEvent e) {
		    try {
			String  srvHost    = propsHandler.getSrvHost();
			int     srvPort    = propsHandler.getSrvPort();
			String  localFN    = localFile.getText();
			String  remoteFN   = remoteFile.getText();
			String  curDir     = scpLocFD.getDirectory();
			boolean recursive  = cbRecursive.getState();
			boolean background = cbBackground.getState();

			SSHSCPGUIThread progress =
			    new SSHSCPGUIThread(srvHost, srvPort,
						propsHandler,
						propsHandler, interactor,
						parent, curDir,
						localFN, remoteFN,
						recursive,
						background, toRemote);
		    } catch (Exception ee) {
			SSHMiscDialogs.alert("MindTerm - Alert",
					     "Error starting SCP-tread: " + ee.getMessage(),
					     parent);
		    }
		}
	    });
	    bp.add(cancBut = new Button("Close Dialog"));
	    cancBut.addActionListener(new AWTConvenience.CloseAction(scpDialog));

	    AWTConvenience.setKeyListenerOfChildren(scpDialog,
						    new AWTConvenience.OKCancelAdapter(okBut, cancBut),
						    null);

	    gridc.gridwidth = GridBagConstraints.REMAINDER;
	    gridc.anchor    = GridBagConstraints.CENTER;
	    grid.setConstraints(bp, gridc);
	    scpDialog.add(bp);

	    scpDialog.addWindowListener(new AWTConvenience.CloseAdapter(cancBut));

	    AWTConvenience.setBackgroundOfChildren(scpDialog);

	    scpDialog.setResizable(true);
	    scpDialog.pack();
	}

	scpDialog.setTitle(title);

	AWTConvenience.placeDialog(scpDialog);
	scpDialog.setVisible(true);
    }
}
