// smartmem.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/
 
// SmartMemory handles all memory acquisition that is not done via new, and 
// keeps track of total allocations.  Note that the call to free() includes the
// size of the chunk being freed, for bookkeeping.

class SmartMemory {
public:
	static void setMaxTotalAllocation(unsigned);
	static unsigned maxTotalAllocation() { return max_TotalAllocation; }
	static void setMaxSingleAllocation(unsigned);
	static unsigned maxSingleAllocation() { return max_SingleAllocation; }
	static unsigned totalBytesAllocated() { return totalBytes_Allocated; }

	static void* allocate(unsigned* size);
	static void free(void* ptr, unsigned size);
	static void* changeAllocation(void* ptr, unsigned oldSize, unsigned* size);
	static void* zero(void* ptr, unsigned size, int zero=0);
	static void* copy(void* from, void* to, unsigned size);
protected:
	static int isLegalAllocation(unsigned size);
private:
	static unsigned totalBytes_Allocated;
	static unsigned max_TotalAllocation;
	static unsigned max_SingleAllocation;
};

	