load /home/msp/prog/tcl-gtk/src/libtcl-gtk-0.04.so Tcl_Gtk
load /home/msp/prog/tcl-gtk/src/libtcl-zvt.so Tcl_Zvt

source /home/msp/prog/tcl-gtk/lib/tcl-gtk.tcl

proc mmucl::display {str} {
    variable Mmucl

    regsub -all \n $str \r\n str
    zvt::term feed $Mmucl(gtk,term) $str
}

proc mmucl::interface_init {} {
    variable Mmucl

    set w [gtk::window new toplevel]
    gtk::window set_title $w "Mmucl Gtk"
    gtk::signal connect $w delete_event exit

    set vbox [gtk::vbox new 0 1]

    set mb [gtk::menu_bar new]

    set file_item [gtk::menu_item new_with_label File]
    set file_menu [gtk::menu new]
    
    foreach name {Open Print Preview Close}  {
        set mi [gtk::menu_item new_with_label $name]
        gtk::menu append $file_menu $mi
    }

    gtk::menu_bar append $mb $file_item
    gtk::menu_item set_submenu $file_item $file_menu

    set edit_item [gtk::menu_item new_with_label Edit]
    set edit_menu [gtk::menu new]
    
    foreach name {Alias Action Sub}  {
        set mi [gtk::menu_item new_with_label $name]
        gtk::menu append $edit_menu $mi
    }

    gtk::menu_bar append $mb $edit_item
    gtk::menu_item set_submenu $edit_item $edit_menu

    set term [zvt::term new]
    zvt::term set_blink $term 0
    set Mmucl(gtk,term) $term
    
    set entry [gtk::entry new]

    gtk::box pack_start $vbox $mb  0 0 0
    gtk::box pack_start_defaults $vbox $term
    gtk::box pack_start $vbox $entry 0 0 0

    gtk::container add $w $vbox
    gtk::widget show_all $w

    gtk::signal connect $entry activate [list mmucl::gtk_parse $entry]

    rename interface_init ""
    return
}

proc mmucl::gtk_parse {e} {
    meta_parse [gtk::entry get_text $e]
    gtk::entry set_text $e ""
    
    return
}
