#include "ObjectRepository.h"
#include "AllObjects.h"
#include "GamePlayer.h"


//----------------------------------------------------------------------------
void GamePlayer::CreateObjectPDUVisitor::do_objectPDUBase(ObjectPDUBase *pdu)
{
    pdu->m_id = m_file->readUint16();
}

//----------------------------------------------------------------------------
void GamePlayer::CreateObjectPDUVisitor::do_staticDecorationObjectPDUBase(StaticDecorationObjectPDUBase *pdu)
{
    do_objectPDUBase(pdu);
    pdu->m_x = m_file->readUint16();
    pdu->m_y = m_file->readUint16();
}


//----------------------------------------------------------------------------
void GamePlayer::CreateObjectPDUVisitor::do_visit(BarrierPDU *pdu)
{
    do_staticDecorationObjectPDUBase(pdu);
    pdu->m_orientation = m_file->readUint8();
    pdu->m_activated = m_file->readUint8();
}

//----------------------------------------------------------------------------
void GamePlayer::CreateObjectPDUVisitor::do_visit(BlackHolePDU *pdu)
{
    do_staticDecorationObjectPDUBase(pdu);
}

//----------------------------------------------------------------------------
void GamePlayer::CreateObjectPDUVisitor::do_visit(CratePDU *pdu)
{
    do_staticDecorationObjectPDUBase(pdu);
    pdu->m_type = m_file->readUint8();
}

//----------------------------------------------------------------------------
void GamePlayer::CreateObjectPDUVisitor::do_visit(GrenadePDU *pdu)
{
    do_objectPDUBase(pdu);
    pdu->m_x = m_file->readUint16();
    pdu->m_y = m_file->readUint16();
}

//----------------------------------------------------------------------------
void GamePlayer::CreateObjectPDUVisitor::do_visit(GrinderPDU *pdu)
{
    do_objectPDUBase(pdu);
    pdu->m_x = m_file->readUint16();
    pdu->m_y = m_file->readUint16();
    pdu->m_frame = m_file->readUint8();
}

//----------------------------------------------------------------------------
void GamePlayer::CreateObjectPDUVisitor::do_visit(MagnetBasePDU *pdu)
{
    do_staticDecorationObjectPDUBase(pdu);
    pdu->m_orientation = m_file->readUint8();
    pdu->m_wh = m_file->readUint8();
    pdu->m_frame = m_file->readUint8();
}

//----------------------------------------------------------------------------
void GamePlayer::CreateObjectPDUVisitor::do_visit(MissilePDU *pdu)
{
    do_objectPDUBase(pdu);
    pdu->m_x = m_file->readUint16();
    pdu->m_y = m_file->readUint16();
    pdu->m_angle = m_file->readUint16();
    pdu->m_thrust = m_file->readUint8();
}

//----------------------------------------------------------------------------
void GamePlayer::CreateObjectPDUVisitor::do_visit(MortarBasePDU *pdu)
{
    do_staticDecorationObjectPDUBase(pdu);
    pdu->m_orientation = m_file->readUint8();
}

//----------------------------------------------------------------------------
void GamePlayer::CreateObjectPDUVisitor::do_visit(ParticleFountainBasePDU *pdu)
{
    do_staticDecorationObjectPDUBase(pdu);
    pdu->m_orientation = m_file->readUint8();
}

//----------------------------------------------------------------------------
void GamePlayer::CreateObjectPDUVisitor::do_visit(PlatformPDU *pdu)
{
    do_staticDecorationObjectPDUBase(pdu);
    pdu->m_w = m_file->readUint8();
    pdu->m_leftEdge = m_file->readUint8();
    pdu->m_rightEdge = m_file->readUint8();
    pdu->m_frame = m_file->readUint8();
}

//----------------------------------------------------------------------------
void GamePlayer::CreateObjectPDUVisitor::do_visit(ProjectileBasePDU *pdu)
{
    do_objectPDUBase(pdu);
    pdu->m_x = m_file->readUint16();
    pdu->m_y = m_file->readUint16();
}

//----------------------------------------------------------------------------
void GamePlayer::CreateObjectPDUVisitor::do_visit(SAMBatteryBasePDU *pdu)
{
    do_staticDecorationObjectPDUBase(pdu);
    pdu->m_orientation = m_file->readUint8();
}

//----------------------------------------------------------------------------
void GamePlayer::CreateObjectPDUVisitor::do_visit(ShipPDU *pdu)
{
    do_objectPDUBase(pdu);
    pdu->m_x = m_file->readUint16();
    pdu->m_y = m_file->readUint16();
    pdu->m_type = m_file->readUint8();
    pdu->m_angle = m_file->readUint16();
    pdu->m_thrust = m_file->readUint8();
}

//----------------------------------------------------------------------------
void GamePlayer::CreateObjectPDUVisitor::do_visit(SwitchBasePDU *pdu)
{
    do_staticDecorationObjectPDUBase(pdu);
    pdu->m_orientation = m_file->readUint8();
}

//----------------------------------------------------------------------------
void GamePlayer::CreateObjectPDUVisitor::do_visit(TankPDU *pdu)
{
    do_objectPDUBase(pdu);
    pdu->m_x = m_file->readUint16();
    pdu->m_y = m_file->readUint16();
}

//----------------------------------------------------------------------------
void GamePlayer::CreateObjectPDUVisitor::do_visit(ThornPDU *pdu)
{
    do_staticDecorationObjectPDUBase(pdu);
    pdu->m_orientation = m_file->readUint8();
    pdu->m_size = m_file->readUint16();
}

//----------------------------------------------------------------------------
void GamePlayer::CreateObjectPDUVisitor::do_visit(TurretBasePDU *pdu)
{
    do_staticDecorationObjectPDUBase(pdu);
    pdu->m_orientation = m_file->readUint8();
    pdu->m_type = m_file->readUint8();
}


//----------------------------------------------------------------------------
void GamePlayer::CreateObjectPDUVisitor::do_visit(HeaderPDU *pdu)
{
    assert(false);
}

//----------------------------------------------------------------------------
void GamePlayer::CreateObjectPDUVisitor::do_visit(DeleteObjectPDU *pdu)
{
    assert(false);
}



//----------------------------------------------------------------------------
void GamePlayer::UpdateObjectPDUVisitor::do_visit(BarrierPDU *pdu)
{
    pdu->m_activated = m_file->readUint8();
}

//----------------------------------------------------------------------------
void GamePlayer::UpdateObjectPDUVisitor::do_visit(BlackHolePDU *pdu)
{
    assert(false);
}

//----------------------------------------------------------------------------
void GamePlayer::UpdateObjectPDUVisitor::do_visit(CratePDU *pdu)
{
    assert(false);
}

//----------------------------------------------------------------------------
void GamePlayer::UpdateObjectPDUVisitor::do_visit(GrenadePDU *pdu)
{
    pdu->m_x = m_file->readUint16();
    pdu->m_y = m_file->readUint16();
}

//----------------------------------------------------------------------------
void GamePlayer::UpdateObjectPDUVisitor::do_visit(GrinderPDU *pdu)
{
    pdu->m_x = m_file->readUint16();
    pdu->m_y = m_file->readUint16();
    pdu->m_frame = m_file->readUint8();
}

//----------------------------------------------------------------------------
void GamePlayer::UpdateObjectPDUVisitor::do_visit(MagnetBasePDU *pdu)
{
    pdu->m_frame = m_file->readUint8();
}

//----------------------------------------------------------------------------
void GamePlayer::UpdateObjectPDUVisitor::do_visit(MissilePDU *pdu)
{
    pdu->m_x = m_file->readUint16();
    pdu->m_y = m_file->readUint16();
    pdu->m_angle = m_file->readUint16();
    pdu->m_thrust = m_file->readUint8();
}

//----------------------------------------------------------------------------
void GamePlayer::UpdateObjectPDUVisitor::do_visit(MortarBasePDU *pdu)
{
    assert(false);
}

//----------------------------------------------------------------------------
void GamePlayer::UpdateObjectPDUVisitor::do_visit(ParticleFountainBasePDU *pdu)
{
    assert(false);
}

//----------------------------------------------------------------------------
void GamePlayer::UpdateObjectPDUVisitor::do_visit(PlatformPDU *pdu)
{
    pdu->m_frame = m_file->readUint8();
}

//----------------------------------------------------------------------------
void GamePlayer::UpdateObjectPDUVisitor::do_visit(ProjectileBasePDU *pdu)
{
    pdu->m_x = m_file->readUint16();
    pdu->m_y = m_file->readUint16();
}

//----------------------------------------------------------------------------
void GamePlayer::UpdateObjectPDUVisitor::do_visit(SAMBatteryBasePDU *pdu)
{
    assert(false);
}

//----------------------------------------------------------------------------
void GamePlayer::UpdateObjectPDUVisitor::do_visit(ShipPDU *pdu)
{
    pdu->m_x = m_file->readUint16();
    pdu->m_y = m_file->readUint16();
    pdu->m_angle = m_file->readUint16();
    pdu->m_thrust = m_file->readUint8();
}

//----------------------------------------------------------------------------
void GamePlayer::UpdateObjectPDUVisitor::do_visit(SwitchBasePDU *pdu)
{
    assert(false);
}

//----------------------------------------------------------------------------
void GamePlayer::UpdateObjectPDUVisitor::do_visit(TankPDU *pdu)
{
    pdu->m_x = m_file->readUint16();
    pdu->m_y = m_file->readUint16();
}

//----------------------------------------------------------------------------
void GamePlayer::UpdateObjectPDUVisitor::do_visit(ThornPDU *pdu)
{
    pdu->m_size = m_file->readUint16();
}

//----------------------------------------------------------------------------
void GamePlayer::UpdateObjectPDUVisitor::do_visit(TurretBasePDU *pdu)
{
    assert(false);
}


//----------------------------------------------------------------------------
void GamePlayer::UpdateObjectPDUVisitor::do_visit(HeaderPDU *pdu)
{
    assert(false);
}

//----------------------------------------------------------------------------
void GamePlayer::UpdateObjectPDUVisitor::do_visit(DeleteObjectPDU *pdu)
{
    assert(false);
}



//----------------------------------------------------------------------------
void GamePlayer::CreateGameObjectPDUVisitor::do_visit(BarrierPDU *pdu)
{
    Barrier::InitializationData init;
    init.id = pdu->m_id;
    init.x = pdu->m_x;
    init.y = pdu->m_y;
    init.orientation =
        static_cast<HVDecorationBase::Orientation>(pdu->m_orientation);
    init.wh = pdu->m_wh;
    init.activatedPresent = true;
    init.activated = pdu->m_activated;

    ObjectRepository::getInstance()->addObject(new Barrier(init));
}

//----------------------------------------------------------------------------
void GamePlayer::CreateGameObjectPDUVisitor::do_visit(BlackHolePDU *pdu)
{
    BlackHole::InitializationData init;
    init.id = pdu->m_id;
    init.x = pdu->m_x;
    init.y = pdu->m_y;
    
    ObjectRepository::getInstance()->addObject(new BlackHole(init));
}

//----------------------------------------------------------------------------
void GamePlayer::CreateGameObjectPDUVisitor::do_visit(CratePDU *pdu)
{
    Crate::InitializationData init;
    init.id = pdu->m_id;
    init.x = pdu->m_x;
    init.y = pdu->m_y;
    init.type = static_cast<CrateSurfaces::Type>(pdu->m_type);

    ObjectRepository::getInstance()->addObject(new Crate(init));
}

//----------------------------------------------------------------------------
void GamePlayer::CreateGameObjectPDUVisitor::do_visit(GrenadePDU *pdu)
{
    assert(false);
}

//----------------------------------------------------------------------------
void GamePlayer::CreateGameObjectPDUVisitor::do_visit(GrinderPDU *pdu)
{
    Grinder::InitializationData init;
    init.id = pdu->m_id;

    ObjectRepository::getInstance()->addObject(new Grinder(init));
}

//----------------------------------------------------------------------------
void GamePlayer::CreateGameObjectPDUVisitor::do_visit(MagnetBasePDU *pdu)
{
    MagnetBase::InitializationData init;
    init.id = pdu->m_id;
    init.x = pdu->m_x;
    init.y = pdu->m_y;
    init.orientation =
        static_cast<OrientatingDecorationBase::Orientation>(
            pdu->m_orientation);
    init.wh = pdu->m_wh;

    ObjectRepository::getInstance()->addObject(MagnetBase::create(init));
}

//----------------------------------------------------------------------------
void GamePlayer::CreateGameObjectPDUVisitor::do_visit(MissilePDU *pdu)
{
    assert(false);
}

//----------------------------------------------------------------------------
void GamePlayer::CreateGameObjectPDUVisitor::do_visit(MortarBasePDU *pdu)
{
    MortarBase::InitializationData init;
    init.id = pdu->m_id;
    init.x = pdu->m_x;
    init.y = pdu->m_y;
    init.orientation =
        static_cast<OrientatingDecorationBase::Orientation>(
            pdu->m_orientation);

    ObjectRepository::getInstance()->addObject(MortarBase::create(init));
}

//----------------------------------------------------------------------------
void GamePlayer::CreateGameObjectPDUVisitor::do_visit(ParticleFountainBasePDU *pdu)
{
    ParticleFountainBase::InitializationData init;
    init.id = pdu->m_id;
    init.x = pdu->m_x;
    init.y = pdu->m_y;
    init.orientation =
        static_cast<OrientatingDecorationBase::Orientation>(
            pdu->m_orientation);

    ObjectRepository::getInstance()->addObject(
        ParticleFountainBase::create(init));
}

//----------------------------------------------------------------------------
void GamePlayer::CreateGameObjectPDUVisitor::do_visit(PlatformPDU *pdu)
{
    Platform::InitializationData init;
    init.id = pdu->m_id;
    init.x = pdu->m_x;
    init.y = pdu->m_y;
    init.w = pdu->m_w;
    init.left = static_cast<PlatformSurfaces::EdgeType>(pdu->m_leftEdge);
    init.right = static_cast<PlatformSurfaces::EdgeType>(pdu->m_rightEdge);

    ObjectRepository::getInstance()->addObject(new Platform(init));
}

//----------------------------------------------------------------------------
void GamePlayer::CreateGameObjectPDUVisitor::do_visit(ProjectileBasePDU *pdu)
{
    assert(false);
}

//----------------------------------------------------------------------------
void GamePlayer::CreateGameObjectPDUVisitor::do_visit(SAMBatteryBasePDU *pdu)
{
    SAMBatteryBase::InitializationData init;
    init.id = pdu->m_id;
    init.x = pdu->m_x;
    init.y = pdu->m_y;
    init.orientation =
        static_cast<OrientatingDecorationBase::Orientation>(
            pdu->m_orientation);

    ObjectRepository::getInstance()->addObject(SAMBatteryBase::create(init));
}

//----------------------------------------------------------------------------
void GamePlayer::CreateGameObjectPDUVisitor::do_visit(ShipPDU *pdu)
{
    Ship *ship = new Ship(
        pdu->m_id, static_cast<ShipSurfaces::Ship>(pdu->m_type));
    ship->setPosition(pdu->m_x, pdu->m_y);

    ObjectRepository::getInstance()->addObject(ship);
}

//----------------------------------------------------------------------------
void GamePlayer::CreateGameObjectPDUVisitor::do_visit(SwitchBasePDU *pdu)
{
    SwitchBase::InitializationData init;
    init.id = pdu->m_id;
    init.x = pdu->m_x;
    init.y = pdu->m_y;
    init.orientation =
        static_cast<OrientatingDecorationBase::Orientation>(
            pdu->m_orientation);

    ObjectRepository::getInstance()->addObject(SwitchBase::create(init));
}

//----------------------------------------------------------------------------
void GamePlayer::CreateGameObjectPDUVisitor::do_visit(TankPDU *pdu)
{
    Tank::InitializationData init;
    init.id = pdu->m_id;
    init.x = pdu->m_x;
    init.y = pdu->m_y;

    ObjectRepository::getInstance()->addObject(new Tank(init));
}

//----------------------------------------------------------------------------
void GamePlayer::CreateGameObjectPDUVisitor::do_visit(ThornPDU *pdu)
{
    Thorn::InitializationData init;
    init.id = pdu->m_id;
    init.x = pdu->m_x;
    init.y = pdu->m_y;
    init.orientation =
        static_cast<OrientatingDecorationBase::Orientation>(
            pdu->m_orientation);
    init.wh = pdu->m_size;

    ObjectRepository::getInstance()->addObject(new Thorn(init));
}

//----------------------------------------------------------------------------
void GamePlayer::CreateGameObjectPDUVisitor::do_visit(TurretBasePDU *pdu)
{
    TurretBase::InitializationData init;
    init.id = pdu->m_id;
    init.x = pdu->m_x;
    init.y = pdu->m_y;
    init.orientation =
        static_cast<OrientatingDecorationBase::Orientation>(
            pdu->m_orientation);
    init.type = static_cast<TurretSurfaces::Turret>(pdu->m_type);

    ObjectRepository::getInstance()->addObject(TurretBase::create(init));
}


//----------------------------------------------------------------------------
void GamePlayer::CreateGameObjectPDUVisitor::do_visit(HeaderPDU *pdu)
{
    assert(false);
}

//----------------------------------------------------------------------------
void GamePlayer::CreateGameObjectPDUVisitor::do_visit(DeleteObjectPDU *pdu)
{
    assert(false);
}



//----------------------------------------------------------------------------
void GamePlayer::UpdateGameObjectPDUVisitor::do_visit(BarrierPDU *pdu)
{
    Barrier *b = static_cast<Barrier*>(
        ObjectRepository::getInstance()->getObject(pdu->m_id));

    if (pdu->m_activated)
    {
        b->activate();
    }
    else
    {
        b->deactivate();
    }
}

//----------------------------------------------------------------------------
void GamePlayer::UpdateGameObjectPDUVisitor::do_visit(BlackHolePDU *pdu)
{
    assert(false);
}

//----------------------------------------------------------------------------
void GamePlayer::UpdateGameObjectPDUVisitor::do_visit(CratePDU *pdu)
{
    assert(false);
}

//----------------------------------------------------------------------------
void GamePlayer::UpdateGameObjectPDUVisitor::do_visit(GrenadePDU *pdu)
{
    Grenade *g = static_cast<Grenade*>(
        ObjectRepository::getInstance()->getObject(pdu->m_id));
}

//----------------------------------------------------------------------------
void GamePlayer::UpdateGameObjectPDUVisitor::do_visit(GrinderPDU *pdu)
{
    Grinder *g = static_cast<Grinder*>(
        ObjectRepository::getInstance()->getObject(pdu->m_id));
}

//----------------------------------------------------------------------------
void GamePlayer::UpdateGameObjectPDUVisitor::do_visit(MagnetBasePDU *pdu)
{
    MagnetBase *m = static_cast<MagnetBase*>(
        ObjectRepository::getInstance()->getObject(pdu->m_id));
}

//----------------------------------------------------------------------------
void GamePlayer::UpdateGameObjectPDUVisitor::do_visit(MissilePDU *pdu)
{
    Missile *m = static_cast<Missile*>(
        ObjectRepository::getInstance()->getObject(pdu->m_id));
}

//----------------------------------------------------------------------------
void GamePlayer::UpdateGameObjectPDUVisitor::do_visit(MortarBasePDU *pdu)
{
    assert(false);
}

//----------------------------------------------------------------------------
void GamePlayer::UpdateGameObjectPDUVisitor::do_visit(ParticleFountainBasePDU *pdu)
{
    assert(false);
}

//----------------------------------------------------------------------------
void GamePlayer::UpdateGameObjectPDUVisitor::do_visit(PlatformPDU *pdu)
{
    Platform *p = static_cast<Platform*>(
        ObjectRepository::getInstance()->getObject(pdu->m_id));
}

//----------------------------------------------------------------------------
void GamePlayer::UpdateGameObjectPDUVisitor::do_visit(ProjectileBasePDU *pdu)
{
    ProjectileBase *p = static_cast<ProjectileBase*>(
        ObjectRepository::getInstance()->getObject(pdu->m_id));
}

//----------------------------------------------------------------------------
void GamePlayer::UpdateGameObjectPDUVisitor::do_visit(SAMBatteryBasePDU *pdu)
{
    assert(false);
}

//----------------------------------------------------------------------------
void GamePlayer::UpdateGameObjectPDUVisitor::do_visit(ShipPDU *pdu)
{
    Ship *s = static_cast<Ship*>(
        ObjectRepository::getInstance()->getObject(pdu->m_id));
}

//----------------------------------------------------------------------------
void GamePlayer::UpdateGameObjectPDUVisitor::do_visit(SwitchBasePDU *pdu)
{
    assert(false);
}

//----------------------------------------------------------------------------
void GamePlayer::UpdateGameObjectPDUVisitor::do_visit(TankPDU *pdu)
{
    Tank *t = static_cast<Tank*>(
        ObjectRepository::getInstance()->getObject(pdu->m_id));
}

//----------------------------------------------------------------------------
void GamePlayer::UpdateGameObjectPDUVisitor::do_visit(ThornPDU *pdu)
{
    Thorn *t = static_cast<Thorn*>(
        ObjectRepository::getInstance()->getObject(pdu->m_id));
}

//----------------------------------------------------------------------------
void GamePlayer::UpdateGameObjectPDUVisitor::do_visit(TurretBasePDU *pdu)
{
    assert(false);
}


//----------------------------------------------------------------------------
void GamePlayer::UpdateGameObjectPDUVisitor::do_visit(HeaderPDU *pdu)
{
    assert(false);
}

//----------------------------------------------------------------------------
void GamePlayer::UpdateGameObjectPDUVisitor::do_visit(DeleteObjectPDU *pdu)
{
    assert(false);
}



//----------------------------------------------------------------------------
GamePlayer::GamePlayer()
{
    m_file = new File("/tmp/moagg.data", "r");
}

//----------------------------------------------------------------------------
GamePlayer::~GamePlayer()
{
    ZAP_POINTER(m_file);
}

//----------------------------------------------------------------------------
void GamePlayer::readFrame()
{
    Uint16 id = m_file->readUint16();
    Uint16 version = m_file->readUint16();
    Uint16 length = m_file->readUint16();

    assert(id == 0x0000);
    assert(version == 1);

    m_objectIdsToDelete.clear();

    long endPos = m_file->tell() + length;
    while (m_file->tell() < endPos)
    {
        readPDU();
    }

    processPDUs();
}

//----------------------------------------------------------------------------
void GamePlayer::readPDU()
{
    Uint16 pduId = m_file->readUint16();

    if (pduId > 0x0000 && pduId < 0x0100)
    {
        ObjectPDUBase *pdu = createObjectPDU((PDUBase::Ids)pduId);
        CreateObjectPDUVisitor v(m_file);
        pdu->accept(v);
        pdu->m_visited = true;

        m_createdPDUs[pdu->m_id] = pdu;
    }
    else if (pduId > 0x0100 && pduId < 0x0200)
    {
        Uint16 objectId = m_file->readUint16();

        ObjectPDUs::iterator iter = m_activePDUs.find(objectId);
        assert(iter != m_activePDUs.end());

        UpdateObjectPDUVisitor v(m_file);
        iter->second->accept(v);
        iter->second->m_visited = true;
    }
    else if (pduId == 0x0200)
    {
        Uint16 objectId = m_file->readUint16();
        m_objectIdsToDelete.push_back(objectId);
    }
    else
    {
        assert(false);
    }
}

//----------------------------------------------------------------------------
void GamePlayer::processPDUs()
{
    do
    {
        CreateGameObjectPDUVisitor v;
        for (ObjectPDUs::const_iterator
                 iter = m_createdPDUs.begin(),
                 end = m_createdPDUs.end();
             iter != end; ++iter)
        {
            
        }
    }
    while (0);

    do
    {
        UpdateGameObjectPDUVisitor v;
        for (ObjectPDUs::const_iterator
                 iter = m_activePDUs.begin(),
                 end = m_activePDUs.end();
             iter != end; ++iter)
        {
            if (iter->second->m_visited)
            {
                iter->second->accept(v);
            }
        }
    }
    while (0);
}

//----------------------------------------------------------------------------
ObjectPDUBase *GamePlayer::createObjectPDU(const PDUBase::Ids id)
{
    switch (id)
    {
    case PDUBase::CREATE_BARRIER_PDUID:
        return new BarrierPDU();
        break;

    case PDUBase::CREATE_BLACKHOLE_PDUID:
        return new BlackHolePDU();
        break;

    case PDUBase::CREATE_CRATE_PDUID:
        return new CratePDU();
        break;

    case PDUBase::CREATE_GRENADE_PDUID:
        return new GrenadePDU();
        break;

    case PDUBase::CREATE_GRINDER_PDUID:
        return new GrinderPDU();
        break;

    case PDUBase::CREATE_MAGNET_PDUID:
        return new MagnetBasePDU();
        break;

    case PDUBase::CREATE_MISSILE_PDUID:
        return new MissilePDU();
        break;

    case PDUBase::CREATE_MORTAR_PDUID:
        return new MortarBasePDU();
        break;

    case PDUBase::CREATE_PARTICLEFOUNTAIN_PDUID:
        return new ParticleFountainBasePDU();
        break;

    case PDUBase::CREATE_PLATFORM_PDUID:
        return new PlatformPDU();
        break;

    case PDUBase::CREATE_PROJECTILE_PDUID:
        return new ProjectileBasePDU();
        break;

    case PDUBase::CREATE_SAMBATTERY_PDUID:
        return new SAMBatteryBasePDU();
        break;

    case PDUBase::CREATE_SHIP_PDUID:
        return new ShipPDU();
        break;

    case PDUBase::CREATE_SWITCH_PDUID:
        return new SwitchBasePDU();
        break;

    case PDUBase::CREATE_TANK_PDUID:
        return new TankPDU();
        break;

    case PDUBase::CREATE_THORN_PDUID:
        return new ThornPDU();
        break;

    case PDUBase::CREATE_TURRET_PDUID:
        return new TurretBasePDU();
        break;

    default:
        assert(false);
    }

    return NULL;
}
