#include "SDLMixerCalls.h"
#include "SoundMixer.h"
#include "SoundFactory.h"
#include "JukeBox.h"
#include "SoundInterface.h"


//----------------------------------------------------------------------------
SoundInterface *SoundInterface::sm_instance =
    NullSoundInterface::getInstance();

NullSoundInterface NullSoundInterface::sm_instance;
SoundBridge SoundBridge::sm_instance;


//----------------------------------------------------------------------------
void SoundBridge::enableSound()
{
    SoundMixer::getInstance()->enableSound();
}

//----------------------------------------------------------------------------
void SoundBridge::disableSound()
{
    SoundMixer::getInstance()->disableSound();
}

//----------------------------------------------------------------------------
bool SoundBridge::isSoundEnabled() const
{
    return SoundMixer::getInstance()->isSoundEnabled();
}

//----------------------------------------------------------------------------
void SoundBridge::enableMusic()
{
    JukeBox::getInstance()->enable();
}

//----------------------------------------------------------------------------
void SoundBridge::disableMusic()
{
    JukeBox::getInstance()->disable();
}

//----------------------------------------------------------------------------
bool SoundBridge::isMusicEnabled() const
{
    return JukeBox::getInstance()->isEnabled();
}


//----------------------------------------------------------------------------
void SoundBridge::setSoundVolume(Uint8 volume)
{
    SoundMixer::getInstance()->setSoundVolume(volume);
}

//----------------------------------------------------------------------------
Uint8 SoundBridge::getSoundVolume() const
{
    return SoundMixer::getInstance()->getSoundVolume();
}

//----------------------------------------------------------------------------
void SoundBridge::setMusicVolume(Uint8 volume)
{
    SoundMixer::getInstance()->setMusicVolume(volume);
}

//----------------------------------------------------------------------------
Uint8 SoundBridge::getMusicVolume() const
{
    return SoundMixer::getInstance()->getMusicVolume();
}


//----------------------------------------------------------------------------
void SoundBridge::playTitleMusic()
{
    JukeBox::getInstance()->playTitleTrack();
}

//----------------------------------------------------------------------------
void SoundBridge::playInGameMusic()
{
    JukeBox::getInstance()->playInGameTrack();
}

//----------------------------------------------------------------------------
void SoundBridge::playHighScoreMusic1stEntry()
{
    JukeBox::getInstance()->playHighScore1stEntryTrack();
}

//----------------------------------------------------------------------------
void SoundBridge::playHighScoreMusicOtherEntry()
{
    JukeBox::getInstance()->playHighScoreOtherEntryTrack();
}

//----------------------------------------------------------------------------
void SoundBridge::playHighScoreMusicNoEntry()
{
    JukeBox::getInstance()->playHighScoreNoEntryTrack();
}


//----------------------------------------------------------------------------
void SoundBridge::onShipShoot()
{
    if (SoundMixer::getInstance()->isSoundEnabled())
    {
        (void)SDL_MIXER_CALLS::PlayChannel(
            SoundFactory::getInstance()->getChunk(SoundFactory::S_ZAP_1));
    }
}

//----------------------------------------------------------------------------
void SoundBridge::onShipExplosion()
{
    if (SoundMixer::getInstance()->isSoundEnabled())
    {
        (void)SDL_MIXER_CALLS::PlayChannel(
            SoundFactory::getInstance()->getChunk(
                SoundFactory::S_EXPLOSION_1));
    }
}

//----------------------------------------------------------------------------
void SoundBridge::onShipThrustOn()
{
    if (SoundMixer::getInstance()->isSoundEnabled())
    {
        if (m_thrustChannel == -1)
        {
            m_thrustChannel = SDL_MIXER_CALLS::PlayChannel(
                SoundFactory::getInstance()->getChunk(
                    SoundFactory::S_THRUST_1), -1);
        }
    }
}

//----------------------------------------------------------------------------
void SoundBridge::onShipThrustOff()
{
    if (SoundMixer::getInstance()->isSoundEnabled())
    {
        if (m_thrustChannel != -1)
        {
            SDL_MIXER_CALLS::HaltChannel(m_thrustChannel);
            m_thrustChannel = -1;
        }
    }
}

//----------------------------------------------------------------------------
void SoundBridge::onShipPlatformBump()
{
    if (SoundMixer::getInstance()->isSoundEnabled())
    {
        (void)SDL_MIXER_CALLS::PlayChannel(
            SoundFactory::getInstance()->getChunk(
                SoundFactory::S_BUMP_1));
    }
}

//----------------------------------------------------------------------------
void SoundBridge::onShipOutOfFuel()
{
    if (SoundMixer::getInstance()->isSoundEnabled())
    {
        (void)SDL_MIXER_CALLS::PlayChannel(
            SoundFactory::getInstance()->getChunk(
                SoundFactory::S_SWEEP_1));
    }
}

//----------------------------------------------------------------------------
void SoundBridge::onCratePickUp()
{
    if (SoundMixer::getInstance()->isSoundEnabled())
    {
        // @todo
    }
}

//----------------------------------------------------------------------------
void SoundBridge::onCrateUnload()
{
    if (SoundMixer::getInstance()->isSoundEnabled())
    {
        (void)SDL_MIXER_CALLS::PlayChannel(
            SoundFactory::getInstance()->getChunk(SoundFactory::S_DING_1));
    }
}

//----------------------------------------------------------------------------
void SoundBridge::onMissileExplosion()
{
    if (SoundMixer::getInstance()->isSoundEnabled())
    {
        (void)SDL_MIXER_CALLS::PlayChannel(
            SoundFactory::getInstance()->getChunk(
                SoundFactory::S_EXPLOSION_2));
    }
}

//----------------------------------------------------------------------------
void SoundBridge::onTurretShoot()
{
    if (SoundMixer::getInstance()->isSoundEnabled())
    {
        (void)SDL_MIXER_CALLS::PlayChannel(
            SoundFactory::getInstance()->getChunk(SoundFactory::S_ZAP_1));
    }
}

//----------------------------------------------------------------------------
void SoundBridge::onTurretExplosion()
{
    if (SoundMixer::getInstance()->isSoundEnabled())
    {
        (void)SDL_MIXER_CALLS::PlayChannel(
            SoundFactory::getInstance()->getChunk(
                SoundFactory::S_EXPLOSION_3));
    }
}

//----------------------------------------------------------------------------
void SoundBridge::onMortarShoot()
{
    if (SoundMixer::getInstance()->isSoundEnabled())
    {
        (void)SDL_MIXER_CALLS::PlayChannel(
            SoundFactory::getInstance()->getChunk(SoundFactory::S_ZAP_1));
    }
}

//----------------------------------------------------------------------------
void SoundBridge::onMortarExplosion()
{
    if (SoundMixer::getInstance()->isSoundEnabled())
    {
        (void)SDL_MIXER_CALLS::PlayChannel(
            SoundFactory::getInstance()->getChunk(
                SoundFactory::S_EXPLOSION_3));
    }
}

//----------------------------------------------------------------------------
void SoundBridge::onTankShoot()
{
    if (SoundMixer::getInstance()->isSoundEnabled())
    {
        (void)SDL_MIXER_CALLS::PlayChannel(
            SoundFactory::getInstance()->getChunk(SoundFactory::S_ZAP_1));
    }
}

//----------------------------------------------------------------------------
void SoundBridge::onTankExplosion()
{
    if (SoundMixer::getInstance()->isSoundEnabled())
    {
        (void)SDL_MIXER_CALLS::PlayChannel(
            SoundFactory::getInstance()->getChunk(
                SoundFactory::S_EXPLOSION_3));
    }
}

//----------------------------------------------------------------------------
void SoundBridge::onSAMBatteryShoot()
{
    if (SoundMixer::getInstance()->isSoundEnabled())
    {
        // @todo
    }
}

//----------------------------------------------------------------------------
void SoundBridge::onSAMBatteryExplosion()
{
    if (SoundMixer::getInstance()->isSoundEnabled())
    {
        (void)SDL_MIXER_CALLS::PlayChannel(
            SoundFactory::getInstance()->getChunk(
                SoundFactory::S_EXPLOSION_3));
    }
}

//----------------------------------------------------------------------------
void SoundBridge::onProjectileExplosion()
{
    if (SoundMixer::getInstance()->isSoundEnabled())
    {
        (void)SDL_MIXER_CALLS::PlayChannel(
            SoundFactory::getInstance()->getChunk(SoundFactory::S_ZAP_2));
    }
}

//----------------------------------------------------------------------------
void SoundBridge::onGrenadeExplosion()
{
    if (SoundMixer::getInstance()->isSoundEnabled())
    {
        (void)SDL_MIXER_CALLS::PlayChannel(
            SoundFactory::getInstance()->getChunk(
                SoundFactory::S_EXPLOSION_3));
    }
}

//----------------------------------------------------------------------------
void SoundBridge::onAddFuelToScore()
{
    if (SoundMixer::getInstance()->isSoundEnabled())
    {
        (void)SDL_MIXER_CALLS::PlayChannel(
            SoundFactory::getInstance()->getChunk(SoundFactory::S_WARP_1));
    }
}

//----------------------------------------------------------------------------
void SoundBridge::onAddBonusToScore()
{
    if (SoundMixer::getInstance()->isSoundEnabled())
    {
        (void)SDL_MIXER_CALLS::PlayChannel(
            SoundFactory::getInstance()->getChunk(SoundFactory::S_CASH_1));
    }
}
