///////////////////////////////////////////////////////////////////////////////
// $Id: indexfile.h,v 1.1.1.1 2003/10/26 20:55:18 krake Exp $
//
// Package:   MOAGG Edit - Level Editor for MOAGG
// Copyright: Kevin Krammer, 2003
//
///////////////////////////////////////////////////////////////////////////////
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.
//
///////////////////////////////////////////////////////////////////////////////

/*! \file    indexfile.h
    \author  Kevin Krammer, kevin.krammer@gmx.at
    \brief   Declaration of the index file handler class
*/

#ifndef INDEXFILE_H
#define INDEXFILE_H

// Qt includes
#include <qstringlist.h>

///////////////////////////////////////////////////////////////////////////////

//! Class handling files containing indices -> file name mappings
/*!
*/

class IndexFile {
public:
	IndexFile();
	~IndexFile();

	bool openFile(const QString& filename);

	inline uint count() const { return m_files.count(); }

	inline QStringList files() const { return m_files; }

private:
	QStringList m_files;

private:
	void parseLine(const QString& line, uint linenum, const QString& filename);
};

#endif

// End of file

