///////////////////////////////////////////////////////////////////////////////
// $Id: resizedialog.h,v 1.1.1.1 2003/10/26 20:55:18 krake Exp $
//
// Package:   MOAGG Edit - Level Editor for MOAGG
// Copyright: Kevin Krammer, 2003
//
///////////////////////////////////////////////////////////////////////////////
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.
//
///////////////////////////////////////////////////////////////////////////////

/*! \file    resizedialog.h
    \author  Kevin Krammer, kevin.krammer@gmx.at
    \brief   Declaration of ResizeDialog class
*/

#ifndef RESIZEDIALOG_H
#define RESIZEDIALOG_H

// local includes
#include "resizedialogbase.h"

///////////////////////////////////////////////////////////////////////////////

//! Dialog for size input
/*!
*/

class ResizeDialog : public ResizeDialogBase
{
	Q_OBJECT
public: 
	ResizeDialog(QWidget* parent=0, const char* name=0);
	virtual ~ResizeDialog();

	void setNumRows(int rows);
	void setNumCols(int cols);
	int numRows() const;
	int numCols() const;
	
protected slots:
	void slotLevelSizeChanged();
	void slotScreenSizeChanged();
};

#endif

// End of file

