/*
** Modular Logfile Analyzer
** Copyright 2000 Jan Kneschke <jan@kneschke.de>
**
** Homepage: http://www.kneschke.de/projekte/modlogan
**

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version, and provided that the above
    copyright and permission notice is included with all distributed
    copies of this or derived software.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA

**
** $Id: pictures.h,v 1.8 2001/10/18 22:53:12 ostborn Exp $
*/

#ifndef _PICTURES_H_
#define _PICTURES_H_

#include "mconfig.h"
#include "mlist.h"
#include "mstate.h"

char *create_pic_12_month(mconfig *conf, mlist *history, const char *subpath);
char *create_pic_31_day(mconfig *conf, mstate *state, const char *subpath);
char *create_pic_24_hour(mconfig *conf, mstate *state, const char *subpath);
char *create_pic_countries(mconfig *conf, mstate *state, const char *subpath);
char *create_pic_vpl(mconfig *ext_conf, mstate *state, const char *subpath);
char *create_pic_vd(mconfig *ext_conf, mstate *state, const char *subpath);
char *create_pic_ext(mconfig *ext_conf, mstate *state, const char *subpath);
char *create_pic_status(mconfig *ext_conf, mstate *state, const char *subpath);
char *create_pic_vhost(mconfig *ext_conf, mstate *state, const char *subpath);

typedef struct {
	char *color;
	char *name;
	double *values;
} mgraph_array;

typedef struct {
	char *name;
	int max_x;
	int max_z;
	char *filename;
	mgraph_array **pairs;
	char **pair_names;
	int width;
	int height;
} mgraph;

int create_bars(mconfig *ext_conf, mgraph *graph);
int create_pie(mconfig *ext_conf, mgraph *graph);
int create_lines(mconfig *ext_conf, mgraph *graph);

#endif
