/*
** Modular Logfile Analyzer
** Copyright 2000 Jan Kneschke <jan@kneschke.de>
**
** Homepage: http://www.kneschke.de/projekte/modlogan
**

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version, and provided that the above
    copyright and permission notice is included with all distributed
    copies of this or derived software.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA

**
** $Id: plugin_config.h,v 1.11 2002/01/04 14:00:27 ostborn Exp $
*/
#ifndef _OUTPUT_PLUGIN_CONFIG_H_
#define _OUTPUT_PLUGIN_CONFIG_H_

#include <stdio.h>
#include "mlist.h"
#include "mstate.h"
#include "mtree.h"

typedef struct {
	const char *key;
	const char *title;
	char *(*func)(mconfig *ext_conf, mstate *state, const char *current, int max, const char *subpath);
} tmpl_reports;

#define M_TMPL_MAX_REPORTS 256

typedef struct {
	char *template_path;
	char *template_name;
	
	/* Colors for column headings etc. */
	char *col_pages;
	char *col_files;
	char *col_visits;
	char *col_xfer;
	char *col_hits;
	char *col_backgnd;
	char *col_shadow;
	char *col_border;
	char *col_foregnd;
	
	int show_reports;

	mlist *col_circle;
	mlist *col_vhostcircle;
	
	char *assumedprotocol;
	char *hostname;
	char *filename_pattern;
	char *index_filename;
	
	char *tmpl_menu;
	char *tmpl_outer;
	char *tmpl_table;
	char *tmpl_index;
	
	mlist   *variables,
		*reports,
		*files,
		*menuentry,
		*menutitle;
	
	mtree   *menu;
	tmpl_reports avail_reports[M_TMPL_MAX_REPORTS];
} config_output;

int mplugins_output_generate_monthly_output(mconfig *ext_conf, mstate *state, const char *subpath);
int mplugins_output_generate_history_output(mconfig *ext_conf, mlist *history, const char *subpath);

#endif
