/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.SliderUI;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.gui.JAttributeSlider;
import org.jhotdraw.gui.JAttributeTextField;
import org.jhotdraw.gui.JPopupButton;
import org.jhotdraw.gui.event.FigureAttributeEditorHandler;
import org.jhotdraw.gui.event.SelectionComponentDisplayer;
import org.jhotdraw.gui.event.SelectionComponentRepainter;
import org.jhotdraw.gui.plaf.palette.PaletteButtonUI;
import org.jhotdraw.gui.plaf.palette.PaletteFormattedTextFieldUI;
import org.jhotdraw.gui.plaf.palette.PaletteSliderUI;
import org.jhotdraw.samples.svg.SVGAttributeKeys;
import org.jhotdraw.samples.svg.gui.AbstractToolBar;
import org.jhotdraw.samples.svg.gui.SelectionOpacityIcon;
import org.jhotdraw.text.JavaNumberFormatter;
import org.jhotdraw.util.Images;
import org.jhotdraw.util.ResourceBundleUtil;

public class FigureToolBar
extends AbstractToolBar {
    private SelectionComponentDisplayer displayer;
    private ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.samples.svg.Labels");

    public FigureToolBar() {
        this.setName(this.labels.getString(this.getID() + ".toolbar"));
        this.setDisclosureStateCount(3);
    }

    @Override
    public void setEditor(DrawingEditor drawingEditor) {
        DrawingEditor drawingEditor2 = this.getEditor();
        if (this.displayer != null) {
            this.displayer.dispose();
            this.displayer = null;
        }
        super.setEditor(drawingEditor);
        if (drawingEditor != null) {
            this.displayer = new SelectionComponentDisplayer(this.editor, this);
        }
    }

    @Override
    protected JComponent createDisclosedComponent(int n) {
        JPanel jPanel = null;
        switch (n) {
            case 1: {
                jPanel = new JPanel();
                jPanel.setOpaque(false);
                jPanel.setLayout(new GridBagLayout());
                jPanel.setBorder(new EmptyBorder(5, 5, 5, 8));
                if (this.editor == null) break;
                JPopupButton jPopupButton = new JPopupButton();
                JAttributeSlider jAttributeSlider = new JAttributeSlider(1, 0, 100, 100);
                jPopupButton.add(jAttributeSlider);
                this.labels.configureToolBarButton(jPopupButton, "attribute.figureOpacity");
                jPopupButton.setUI((PaletteButtonUI)PaletteButtonUI.createUI(jPopupButton));
                jPopupButton.setIcon(new SelectionOpacityIcon(this.editor, SVGAttributeKeys.OPACITY, (AttributeKey<Color>)SVGAttributeKeys.FILL_COLOR, (AttributeKey<Color>)SVGAttributeKeys.STROKE_COLOR, Images.createImage(this.getClass(), this.labels.getString("attribute.figureOpacity.icon")), (Shape)new Rectangle(5, 5, 6, 6), (Shape)new Rectangle(4, 4, 7, 7)));
                jPopupButton.setPopupAnchor(4);
                this.disposables.add(new SelectionComponentRepainter(this.editor, jPopupButton));
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 2;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.insets = new Insets(0, 0, 0, 0);
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.anchor = 23;
                jPanel.add((Component)jPopupButton, gridBagConstraints);
                jAttributeSlider.setUI((SliderUI)PaletteSliderUI.createUI(jAttributeSlider));
                jAttributeSlider.setScaleFactor(100.0);
                this.disposables.add(new FigureAttributeEditorHandler<Double>(SVGAttributeKeys.OPACITY, jAttributeSlider, this.editor));
                break;
            }
            case 2: {
                jPanel = new JPanel();
                jPanel.setOpaque(false);
                jPanel.setLayout(new GridBagLayout());
                jPanel.setBorder(new EmptyBorder(5, 5, 5, 8));
                if (this.editor == null) break;
                JAttributeTextField jAttributeTextField = new JAttributeTextField();
                jAttributeTextField.setColumns(3);
                jAttributeTextField.setToolTipText(this.labels.getString("attribute.figureOpacity.toolTipText"));
                jAttributeTextField.setHorizontalAlignment(4);
                jAttributeTextField.putClientProperty("Palette.Component.segmentPosition", "first");
                jAttributeTextField.setUI((PaletteFormattedTextFieldUI)PaletteFormattedTextFieldUI.createUI(jAttributeTextField));
                jAttributeTextField.setFormatterFactory(JavaNumberFormatter.createFormatterFactory(0.0, 1.0, 100.0));
                jAttributeTextField.setHorizontalAlignment(10);
                this.disposables.add(new FigureAttributeEditorHandler<Double>(SVGAttributeKeys.OPACITY, jAttributeTextField, this.editor));
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.insets = new Insets(0, 0, 0, 0);
                gridBagConstraints.anchor = 23;
                gridBagConstraints.weightx = 1.0;
                jPanel.add(jAttributeTextField, gridBagConstraints);
                JPopupButton jPopupButton = new JPopupButton();
                JAttributeSlider jAttributeSlider = new JAttributeSlider(1, 0, 100, 100);
                jPopupButton.add(jAttributeSlider);
                this.labels.configureToolBarButton(jPopupButton, "attribute.figureOpacity");
                jPopupButton.setUI((PaletteButtonUI)PaletteButtonUI.createUI(jPopupButton));
                jPopupButton.setIcon(new SelectionOpacityIcon(this.editor, SVGAttributeKeys.OPACITY, (AttributeKey<Color>)SVGAttributeKeys.FILL_COLOR, (AttributeKey<Color>)SVGAttributeKeys.STROKE_COLOR, Images.createImage(this.getClass(), this.labels.getString("attribute.figureOpacity.icon")), (Shape)new Rectangle(5, 5, 6, 6), (Shape)new Rectangle(4, 4, 7, 7)));
                jPopupButton.setPopupAnchor(4);
                this.disposables.add(new SelectionComponentRepainter(this.editor, jPopupButton));
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 2;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.anchor = 23;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.insets = new Insets(0, 0, 0, 0);
                jPanel.add((Component)jPopupButton, gridBagConstraints);
                jAttributeSlider.setUI((SliderUI)PaletteSliderUI.createUI(jAttributeSlider));
                jAttributeSlider.setScaleFactor(100.0);
                this.disposables.add(new FigureAttributeEditorHandler<Double>(SVGAttributeKeys.OPACITY, jAttributeSlider, this.editor));
            }
        }
        return jPanel;
    }

    @Override
    protected String getID() {
        return "figure";
    }

    private void initComponents() {
    }
}

