/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskTracker;
import org.apache.hadoop.mapred.TaskTrackerInstrumentation;
import org.apache.hadoop.metrics2.MetricsBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.lib.MetricMutableCounterInt;
import org.apache.hadoop.metrics2.lib.MetricMutableGaugeInt;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.source.JvmMetricsSource;

public class TaskTrackerMetricsSource
extends TaskTrackerInstrumentation
implements MetricsSource {
    final MetricsRegistry registry = new MetricsRegistry("tasktracker");
    final MetricMutableGaugeInt mapsRunning = this.registry.newGauge("maps_running", "", 0);
    final MetricMutableGaugeInt redsRunning = this.registry.newGauge("reduces_running", "", 0);
    final MetricMutableGaugeInt mapSlots = this.registry.newGauge("mapTaskSlots", "", 0);
    final MetricMutableGaugeInt redSlots = this.registry.newGauge("reduceTaskSlots", "", 0);
    final MetricMutableCounterInt completedTasks = this.registry.newCounter("tasks_completed", "", 0);
    final MetricMutableCounterInt timedoutTasks = this.registry.newCounter("tasks_failed_timeout", "", 0);
    final MetricMutableCounterInt pingFailedTasks = this.registry.newCounter("tasks_failed_ping", "", 0);

    public TaskTrackerMetricsSource(TaskTracker tt) {
        super(tt);
        String sessionId = tt.getJobConf().getSessionId();
        JvmMetricsSource.create("TaskTracker", sessionId);
        this.registry.setContext("mapred").tag("sessionId", "", sessionId);
    }

    @Override
    public void getMetrics(MetricsBuilder builder, boolean all) {
        this.mapsRunning.set(this.tt.mapTotal);
        this.redsRunning.set(this.tt.reduceTotal);
        this.mapSlots.set(this.tt.getMaxCurrentMapTasks());
        this.redSlots.set(this.tt.getMaxCurrentReduceTasks());
        this.registry.snapshot(builder.addRecord(this.registry.name()), all);
    }

    @Override
    public void completeTask(TaskAttemptID t) {
        this.completedTasks.incr();
    }

    @Override
    public void timedoutTask(TaskAttemptID t) {
        this.timedoutTasks.incr();
    }

    @Override
    public void taskFailedPing(TaskAttemptID t) {
        this.pingFailedTasks.incr();
    }
}

