# copyright (C) 1997-2001 Jean-Luc Fontaine (mailto:jfontain@free.fr)
# this program is free software: please read the COPYRIGHT file enclosed in this package or use the Help Copyright menu

set rcsId {$Id: global.tcl,v 2.50 2001/02/24 21:08:55 jfontain Exp $}


namespace eval global {                                                                     ;# gather miscellaneous global data here
    variable applicationVersion 14.0
    variable debug 0
    variable messenger                                                                                   ;# main window message area
    variable pollTimes                                       ;# list of predefined poll times calculated according to loaded modules
    variable pollTime                                                                               ;# current main window poll time
    variable scroll                                                                ;# main window scroll composite widget identifier
    variable canvas                                                                                ;# main window canvas widget path
    variable menu                                                                                                ;# main window menu
    variable static                                                                            ;# whether main window view is static
    variable windowManager                                                                             ;# main window window manager
    variable fileMenuContextHelper                                             ;# menu context help object for file menu in menu bar
    variable fileMenuContextHelperSaveIndex                                                        ;# save button index in the above
    variable saveFile                                                     ;# current configuration and layout current save file name
    variable xWindowManagerInitialOffset 30
    variable yWindowManagerInitialOffset 20
    variable graphNumberOfIntervals 100
    variable viewerHeight 200
    variable viewerWidth 300
    variable canvasHeight [winfo screenheight .]
    variable canvasWidth [winfo screenwidth .]
    variable canvasBackground white
    variable pieLabeler peripheral
    variable viewerColors {#7FFFFF #7FFF7F #FF7F7F #FFFF7F #7F7FFF #FFBF00 #BFBFBF #FF7FFF #FFFFFF}
    variable documentationDirectory [file dirname $::argv0]/documentation
    variable printToFile 0
    variable fileToPrintTo moodss.ps
    variable printCommand {lpr -P%P}
    variable printOrientations {landscape portrait}
    variable printOrientation portrait
    variable printPalettes {color gray monochrome}
    variable printPalette color
    variable printPaperSizes [list\
        {A3 (297 x 420 millimeters)} {A4 (210 x 297 millimeters)} {executive (7 1/2 x 10 inches)} {legal (8 1/2 x 14 inches)}\
        {letter (8 1/2 x 11 inches)}\
    ]
    variable printPaperSize [lindex $printPaperSizes end]                                                   ;# letter is the default
    variable fromAddress $::env(USER)
    variable smtpServers 127.0.0.1
}

proc updateCanvasSize {args} {                                                                             ;# ignore trace arguments
    $global::canvas configure -width $global::canvasWidth -height $global::canvasHeight\
        -scrollregion [list 0 0 $global::canvasWidth $global::canvasHeight]
}

proc updateCanvasBackground {args} {                                                                       ;# ignore trace arguments
    $global::canvas configure -background $global::canvasBackground
}
