# copyright (C) 1997-2001 Jean-Luc Fontaine (mailto:jfontain@free.fr)
# this program is free software: please read the COPYRIGHT file enclosed in this package or use the Help Copyright menu

set rcsId {$Id: graph.tcl,v 2.10 2000/12/31 23:14:19 jfontain Exp $}


class bltGraph {                         ;# this is common code for all BLT viewers of graph type (includes stripchart and barchart)

    proc bltGraph {this path} {
        $path xaxis configure -tickfont $font::(smallNormal) -title {} -rotate 90 -command bltGraph::axisTime -tickshadow {}
        bind $path <Configure> "bltGraph::resized $this"                                                       ;# track size updates
        set marker [$path marker create polygon -fill {} -coords {-Inf Inf Inf Inf Inf -Inf -Inf -Inf}]
        $path crosshairs configure -color blue
        $path marker bind $marker <Enter> "bltGraph::enterPlotArea $path %x %y"
        $path marker bind $marker <Leave> "bltGraph::leavePlotArea $path"
        set ($this,path) $path
        set ($this,plotWidth) 0                                                                                  ;# cache plot width
    }

    proc ~bltGraph {this} {}

    proc setRange {this value} {
        set ($this,range) $value
    }

    proc xAxisUpdate {this currentTime} {
        if {($($this,plotWidth)==0)||($($this,range)==0)} return       ;# wait till graph window is drawn first and range is defined
        $($this,path) xaxis configure -min [expr {$currentTime-$($this,range)}] -max $currentTime
    }

    proc axisTime {path value} {
        set value [expr {round($value)}]                                                        ;# BLT passes a floating point value
        if {($value%60)==0} {
            return [clock format $value -format %H:%M]
        } else {
            return [clock format $value -format %T]                                              ;# show seconds only when necessary
        }
    }

    proc updateGraduations {this} {
        if {$($this,plotWidth)==0} return                                                             ;# plot width is not known yet
        # number=$division*($range/$step)                                                                      # number of divisions
        # ($plotWidth/$number)>2                              # make sure that there is at least 1 pixel between neighbour divisions
        # => $step>((2*$division*$range)/$plotWidth)
        # use the maximum division in divisions discrete list
        set minimum [expr {(2*6*$($this,range))/$($this,plotWidth)}]
        # choose among predefined discrete values
        foreach step {10 60 300 600 1800 3600 18000 36000 86400} division {5 6 5 5 5 6 5 5 4} {
            if {$step>$minimum} break
        }
        $($this,path) xaxis configure -stepsize $step -subdivisions $division
        xAxisUpdate $this [clock seconds]
    }

    proc resized {this} {
        update idletasks                                                                              ;# make sure sizes are correct
        set width [$($this,path) extents plotwidth]
        if {$width!=$($this,plotWidth)} {
            set ($this,plotWidth) $width
            updateGraduations $this                                                       ;# optimize graduations for new plot width
        }
    }

    proc enterPlotArea {path x y} {
        $path configure -cursor tcross
        $path crosshairs on
        bind $path <Any-Motion> "bltGraph::processMotion $path %x %y"
        lifoLabel::push $global::messenger "[axisTime $path $x] $y"
    }

    proc leavePlotArea {path} {
        $path configure -cursor {}
        $path crosshairs off
        bind $path <Any-Motion> {}
        lifoLabel::pop $global::messenger
    }

    proc processMotion {path x y} {
        $path crosshairs configure -position @$x,$y
        foreach {x y} [$path invtransform $x $y] {}
        lifoLabel::pop $global::messenger
        lifoLabel::push $global::messenger "[axisTime $path $x] $y"
    }

}
