# copyright (C) 1997-2001 Jean-Luc Fontaine (mailto:jfontain@free.fr)
# this program is free software: please read the COPYRIGHT file enclosed in this package or use the Help Copyright menu

set rcsId {$Id: modpython.tcl,v 1.2 2001/02/28 20:33:23 jfontain Exp $}


namespace eval module::python {                       ;# indentation removed in some places since Python is quite sensitive about it

variable utilityFunctions {

def columnstring(dictionary, index):
    "return a Tcl array compatible initialization list for column data"
    string = ''
    for (key, value) in dictionary.items():
        string = string + ' {' + str(index) + ',' + str(key) + '} {' + str(value) + '}'
    return string

def liststring(list):
    "return a Tcl list from a python list"
    string = ''
    for index in range(len(list)):
        string = string + ' {' + str(list[index]) + '}'
    return string

def viewsstring(list):
    "return a Tcl array compatible initialization list for views data"
    string = ''
    for index in range(len(list)):
        string = string + ' {'
        for (key, value) in list[index].items():
            string = string + ' {' + str(key) + '}'
            if key == 'swap':                                                                                       # simple boolean
                string = string + ' {' + str(value) + '}'
            elif key == 'sort':
                for (column, direction) in value.items():
                    string = string + ' {{' + str(column) + '} {' + str(direction) + '}}'
                    break                                                                                    # keep first entry only
            else:                                                                                                     # indices list
                string = string + ' {' + liststring(value) + '}'
        string = string + '}'
    return string

def dictionarystring(dictionary):
    "return a Tcl array compatible initialization list from a python dictionary"
    string = ''
    for (key, value) in dictionary.items():
        string = string + ' {' + str(key) + '} {' + str(value) + '}'
    return string

def formstring(dictionary):
    "return a Tcl array compatible initialization list from module form dictionary"
    string = ''
    for (key, value) in dictionary.items():
        if key == 'columns':
            for index in range(len(value)):
                string = string + columnstring(value[index], index)
        elif re.match('^(indexColumns|indices|pollTimes)$', key):
            string = string + ' ' + key + ' {' + liststring(value) + '}'
        elif key == 'sort':
            for (column, direction) in value.items():
                string = string + ' sort {{' + str(column) + '} {' + str(direction) + '}}'
                break                                                                                        # keep first entry only
        elif key == 'switches':
            string = string + ' ' + key + ' {' + dictionarystring(value) + '}'
        elif key == 'views':
            string = string + ' ' + key + ' {' + viewsstring(value) + '}'
        else:
            string = string + ' {' + str(key) + '} {' + str(value) + '}'
    return string

def datastring(list):
    "return a Tcl array compatible initialization list from module data list of lists"
    string = ''
    for row in range(len(list)):
        # empty rows ar handled properly since their length is zero:
        for column in range(len(list[row])):
            string = string + ' ' + str(row) + ',' + str(column) + ' {' + str(list[row][column]) + '}'
    return string

}

}
