# copyright (C) 1997-2001 Jean-Luc Fontaine (mailto:jfontain@free.fr)
# this program is free software: please read the COPYRIGHT file enclosed in this package or use the Help Copyright menu

set rcsId {$Id: misc.tcl,v 1.3 2000/12/31 23:14:19 jfontain Exp $}


package provide miscellaneous [lindex {$Revision: 1.3 $} 1]


proc minimum {a b} {return [expr {$a<$b?$a:$b}]}
proc maximum {a b} {return [expr {$a>$b?$a:$b}]}

proc ldelete {listName value} {
    upvar $listName list

    set index [lsearch -exact $list $value]
    if {$index<0} {
        error "\"$value\" is not in list"
    }
    set list [lreplace $list $index $index]
}

proc static {localName {initialValue {}}} {
    set global ::[lindex [info level -1] 0]:$localName
    uplevel upvar #0 $global $localName
    if {![info exists $global]} {
        set $global $initialValue
    }
}

proc formattedTime {seconds} {
    set string {}
    set interval [expr {$seconds/86400}]                                                                                     ;# days
    if {$interval>0} {
        append string ${interval}d
        set seconds [expr {$seconds%86400}]
    }
    set interval [expr {$seconds/3600}]                                                                                     ;# hours
    if {$interval>0} {
        append string ${interval}h
        set seconds [expr {$seconds%3600}]
    }
    set interval [expr {$seconds/60}]                                                                                     ;# minutes
    if {$interval>0} {
        append string ${interval}m
        set seconds [expr {$seconds%60}]
    }
    append string ${seconds}s
    return $string
}
