# copyright (C) 1997-2001 Jean-Luc Fontaine (mailto:jfontain@free.fr)
# this program is free software: please read the COPYRIGHT file enclosed in this package or use the Help Copyright menu

set rcsId {$Id: network.tcl,v 1.12 2000/12/31 23:14:19 jfontain Exp $}

package provide network [lindex {$Revision: 1.12 $} 1]

namespace eval network {

    proc parseRemoteLocator {string} {                                                        ;# return protocol, user and host list
        regexp {^(([^:]*)://)?(([^@]*)@)?(.*)$} [string trim $string] dummy dummy protocol dummy user host
        if {[string length $protocol]==0} {
            set protocol rsh
        }
        if {![regexp {^(rsh|ssh)$} $protocol]} {
            error "unsupported protocol: $protocol"
        }
        if {[string length $user]==0} {
            set user $::env(USER)
        }
        return [list $protocol $user $host]
    }

    proc checkRemoteOutputEmptiness {protocol user host} {
        catch "exec /usr/bin/$protocol -n -l $user $host :" output
        if {[string length $output]>0} {
            error "remote host \"$host\" error:\n$output"
        }
    }

}
