.\" Copyright (c) 2000, 2001, Amnon BARAK (amnon@cs.huji.ac.il).
.\" All rights reserved.
.\"
.\"	MOSIX tune.man,v 1.1.1.1 1999/01/28 09:58:13 arielr Exp
.\"
.\" THIS MANUAL IS PROVIDED IN ITS "AS IS" CONDITION, WITH NO WARRANTY
.\" WHATSOEVER. NO LIABILITY OF ANY KIND FOR DAMAGES WHATSOEVER RESULTING
.\" FROM THE USE OF THIS MANUAL WILL BE ACCEPTED.
.\"
.Dd May 11, 1997
.Dt TUNE 1
.ds vT MOSIX Reference Manual
.Os MOSIX
.Sh NAME
.Nm \&tune
.Nd calibrate MOSIX kernel parameters to suit processor and network
.Sh SYNOPSIS
.Nm \&tune
.Nm \&mtune
.Nm \&tune_kernel
.Nm \&prep_tune
.Sh DESCRIPTION
.Nm \&tune
measures the timing of certain kernel operations in MOSIX,
resulting in 14 tuning parameters.
Similarly,
.Nm \&mtune
measures the timing of MFS operations, producing 6 other tuning parameters.
.Pp
Although the MOSIX kernel will run reasonably well with the pre-supplied
parameters, optimal results are achieved by measuring different parameters
for each set of nodes whose hardware differs by one or more of the following:
.sp
.Bl -tag -width abc -item -compact
.It 1.
the processor
.It 2.
the type or speed of the memory
.It 3.
the number of memory wait-states (if any)
.It 4.
the networking hardware
.It 5.
whether the kernel has the SMP option configured or not
.El
.Pp
.Nm \&tune
produces two output files, corresponding to two different methods of
installing the parameters:
The first output file, named
.Pa dscosts.h ,
is to be included as is in the kernel sources:
.Pa {kernel_directory}/include/mos/dscosts.h .
The other output file,
.Pa mosix.costs ,
contains the 14 integer tuning parameters:  when copied to the file
.Pa /proc/mosix/admin/overheads ,
those parameters override the kernel's built-in parameters from
.Pa dscosts.h .
In paraticular, if
.Pa mosix.costs
is copied to the file
.Pa /etc/overheads ,
the tuning parameters will be loaded at boot time (when MOSIX is being
configured).
.Pp
Similarly,
.Nm \&mtune
produces two output files, corresponding to two different methods of
installing the parameters:
The first output file, named
.Pa mfscosts.h ,
is to be included as is in the kernel sources:
.Pa {kernel_directory}/include/mos/mfscosts.h .
The other output file,
.Pa mfs.costs ,
contains the 6 integer tuning parameters:  when copied to the file
.Pa /proc/mosix/admin/mfscosts ,
those parameters override the kernel's built-in parameters from
.Pa mfscosts.h .
In paraticular, if
.Pa mfs.costs
is copied to the file
.Pa /etc/mfscosts ,
the MFS tuning parameters will be loaded at boot time (when MOSIX is being
configured).
.Pp
.Nm \&tune_kernel
is a more user-friendly front-end script to
.Nm \&tune
and
.Nm \&mtune ,
guiding the system-administrator through the tuning procedure.
There is no need for the common system-administrator to run
.Nm \&tune
(or
.Nm \&mtune )
directly (but if choosing to do so anyway, one must either run them in the
.Pa /sbin
directory, or first copy the file
.Pa /sbin/tunepass
to one's current directory).
.Nm \&tune_kernel
also supports complex network topologies, eg. when the network-distance
is not even between all nodes, provided that the kernel is configured to
support complex topologies.  In that case, it combines the outputs of
several invocations of
.Pa tune
and/or
.Pa mtune
to produce a complex version of
.Pa /etc/overheads
and/or
.Pa /etc/mfscosts .
.Pp
The pre-requisites for running
.Pa tune
and
.Pa mtune
successfully and obtaining accurate
results are:
.Bl -tag -width abc -item
.It 1.
Have two and only two nodes on the MOSIX network (either disconnect the
others or turn them off).  It is preferable, but not required that both
nodes have the same hardware (otherwise, some manual intervention will
be required by the program and the tuning process will take longer).
.It 2
If any other MOSIX node(s) must remain connected to the network because
they act as routers between the two tested nodes, then MOSIX must be disabled
on those node(s) for the duration of the test (this can be done by running
.Pa setpe -off ) .
.It 3.
Place both nodes in single-user mode.  One way to achieve this is by
typing "telinit 1".  The other way is to boot the nodes straight into
single-user mode.
.It 4
Run
.Pa prep_tune
on the
.Pa other
node
(no need to run it on the node where you run
.Pa tune_kerenl ,
since
.Pa tune_kernel
runs it there automatically).
.Pa prep_tune
does the following:
.Bl -tag -width abc -item -compact
.It a.
enables the network, since it is normally disabled in single-user mode.
.It b.
enables/starts MOSIX.
.It c.\ 
shuts down the (normally active) background operations of MOSIX, so that
other ongoing system-activities do not interfere with the measurements.
.El
.It 4.
Do not touch either keyboard while
.Pa tune
is running.
.Sh USING THE OUTPUT OF TUNE(/MTUNE)
The output of
.Pa tune
(and
.Pa mtune )
is to be used only on the node where
.Pa tune_kernel
was running or on other nodes with identical hardware.
If you have nodes of different hardware, you may need to run
.Pa tune_kernel
several times on different consoles.
.Pp
In a simple cluster, where the network-distance is even between all nodes,
both methods are available: either re-compiling the kernel with the produced
.Pa dscosts.h
.Pa ( mfscosts.h
for
.Pa mtune )
or copying the file
.Pa mosix.costs ,
containing 14 tuning-parameters to
.Pa /etc/overheads
(or
.Pa mfs.costs ,
containing 6 MFS tuning-parameters to
.Pa /etc/mfscosts ) .
.Pp
In a complex cluster, only the second method is available and MOSIX supports
up to CONFIG_MOSIX_MAXTOPOLOGY (configurable in the kernel) different network
distances from each node to CONFIG_MOSIX_MAXTOPOLOGY groups of other nodes.
The
.Pa /etc/overheads
file may therefore contain up to (14+2)*CONFIG_MOSIX_MAXTOPOLOGY
integer constants, where each 14 tuning-parameters are followed by 2 constants:
FIRST and LAST.
.Pp
Similarly, the
.Pa /etc/mfscosts
file may contain up to (6+2)*CONFIG_MOSIX_MAXTOPOLOGY
integer constants, where each 6 MFS tuning-parameters are followed by
2 constants: FIRST and LAST.
.sp
.Bl -tag -width abc -item -compact
.It *
When FIRST <= LAST the preceding 14 (or 6) parameters apply to all MOSIX-nodes
numbered between FIRST and LAST (inclusive).
.It *
When FIRST > LAST the preceding 14 (or 6) parameters apply to all MOSIX-nodes NOT
between LAST and FIRST.
.It *
When FIRST is non-zero and LAST is 0, the preceding 14 parameters (or 6) apply to
all nodes except FIRST.
.It *
When FIRST is 0, the preceding 14 (or 6) parameters include all the remaining nodes.
.El
.sp
The first set of 14 (or 6) parameters also applies to all other unselected
nodes (if any).
.Sh FILES
.Bl -tag -width abcdefghijklmnopq -compact
.It /sbin/tunepass
A supplementary program required by
.Pa tune .
.It /sbin/prep_tune
A script to prepare the system for tuning.
.It dscosts.h
An output of
.Pa tune ,
to be included in the kernel.
.It mfscosts.h
An output of
.Pa mtune ,
to be included in the kernel.
.It mosix.costs
An output of
.Pa tune
containing 14 integer tuning parameters.
.It mfs.costs
An output of
.Pa mtune
containing 6 integer MFS tuning parameters.
.It /proc/mosix/admin/overheads
Where the resulting tuning parameters are written (if different from
the kernel's).
.It /proc/mosix/admin/mfscosts
Where the resulting MFS tuning parameters are written (if different from
the kernel's).
.It /etc/overheads
Tuning parameters.
.It /etc/mfscosts
MFS Tuning parameters.
.Sh SEE ALSO
.Xr mosix 7 ,
.Xr MFS 7 ,
.Xr setpe 1 .
.Sh HISTORY
.Pa tune , mtune
and
.Pa tune_kernel
are MOSIX utilities.
