/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mouse Gesture for Mozilla.
 *
 * The Initial Developer of the Original Code is Pavol Vaskovic.
 * Portions created by the Initial Developer are Copyright (C) 2001
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *  Andy Edmonds <aedmonds@mindspring.com>
 *  Ben Williams <benw@webmedia.com.au>
 *  Benjamin K. Stuhl <tiriath@yahoo.com>
 *  David Illsley <illsleydc@bigfoot.com>
 *  David Perry <d.perry@utoronto.ca>
 *  Jens Bannmann <jens.b@web.de>
 *  Jeremy Wrinkle (Exotrip)        FIXME email
 *  Jochen <bugs@krickelkrackel.de>
 *  Pavol Vaskovic <pali@pali.sk>
 *  Scurrie                         FIXME whole name, email
 *  Steve Kangas <bookmarklets.com> FIXME email
 *  Squarefree.com                  FIXME who exactly: whole name, email
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */


/*** BROWSER FUNCTIONS ***/

var mgBuiltInFunctions = {
  mgB_Back : function() {
    mgBuiltInFunctions.mgClearSelection();
    BrowserBack();
    mgGestureExecute.mgResetRocker();
  },

  mgB_Forward : function() {
    mgBuiltInFunctions.mgClearSelection();
    BrowserForward();
    mgGestureExecute.mgResetRocker();
  },

  mgB_AddBookmark : function() {
    setTimeout(function () {document.getElementById("Browser:AddBookmarkAs").doCommand()}, 50);
  },

  mgB_CloseDoc : function() {
    if (gBrowser.mTabs.length > 1)
      mgBuiltInFunctions.mgB_CloseTab();
    else if (!mgBuiltInFunctions.mgB_ClosePrintPreview())
      mgBuiltInFunctions.mgW_CloseWin();
  },

  mgB_CloseTab : function() {
    if (!mgBuiltInFunctions.mgB_ClosePrintPreview())
      gBrowser.removeCurrentTab();
  },

  mgB_ClosePrintPreview : function() {
    if (document.getElementById("print-preview-toolbar")) {
      PrintUtils.exitPrintPreview();
      return true;
    }

    return false;
  },

  mgB_DoubleImageSize : function() {
    mgBuiltInFunctions.mgSetImageSize(2);
  },

  mgB_DoubleStackWin : function() {
    var tempW;
    if (globalOnLink) {
      window.moveTo(screen.availLeft, screen.availTop);
      window.resizeTo(screen.availWidth/2, screen.availHeight);
      tempW = mgBuiltInFunctions.mgNewBrowserWindow();
      tempW.loadURI(globalOnLink[0].href, mgBuiltInFunctions.mgGetReferrer(globalOnLink[0]));
      tempW.moveTo(screen.availWidth/2 + (screen.width - screen.availWidth),
                   screen.availTop);
      tempW.resizeTo(screen.availWidth/2, screen.availHeight);
    }
  },

  mgB_DuplicateTab : function() {
    if ("duplicateTab" in gBrowser)
      gBrowser.duplicateTab(gBrowser.mCurrentTab);
    else
      gBrowser.addTab(gBrowser.currentURI.spec, null, null);
  },

  mgB_HalveImageSize : function() {
    mgBuiltInFunctions.mgSetImageSize(.5);
  },

  mgB_HideImage : function() {
    if (globalOnImage && mgGestureState.srcEvent.target.nodeName.toLowerCase() == "img")
      mgBuiltInFunctions.mgSetImageSize(0);
  },

  mgB_Home : function() {
    mgBuiltInFunctions.mgClearSelection();
    BrowserHome();
    mgGestureExecute.mgResetRocker();
  },

  mgB_ImagesInTabs : function() {
    for (each in mgGestureState.imageCollection)
      gBrowser.addTab(each, null, null);
  },

  mgB_LinksInTabs : function() {
    for (var i = 0; i < globalOnLink.length; i++)
      var tab = gBrowser.addTab(globalOnLink[i].href, mgBuiltInFunctions.mgGetReferrer(globalOnLink[i]), null);
  },

  mgB_LinksInWindows : function() {
    var max = mgPrefs.prefs.getIntPref("misc.funcPref.mgB_LinksInWindows.maxLinks");

    for (var i = 0; i < globalOnLink.length; i++) {
      if (i >= max)
        break;

      mgBuiltInFunctions.mgNewBrowserWindow().loadURI(globalOnLink[i].href, mgBuiltInFunctions.mgGetReferrer(globalOnLink[i]));
    }
  },

  mgB_NextTab : function() {
    mgBuiltInFunctions.mgAdvanceTab(+1);
  },

  mgB_OpenNewDocument : function() {
    if(globalOnLink) // open link in new window
      mgBuiltInFunctions.mgNewBrowserWindow().loadURI(globalOnLink[0].href, mgBuiltInFunctions.mgGetReferrer(globalOnLink[0]));
    else {
      if (globalOnImage) // Open image in new window
        window.open(globalOnImage.src);
      else // open blank window
        OpenBrowserWindow();
    }
  },

  mgB_OpenTab : function() {
    return mgBuiltInFunctions.mgOpenTab();
  },

  mgB_PreviousTab : function() {
    mgBuiltInFunctions.mgAdvanceTab(-1);
  },

  mgB_Reload : function() {
    BrowserReload();
    mgGestureExecute.mgResetRocker();
  },

  mgB_ReloadSkipCache : function() {
    BrowserReloadSkipCache();
    mgGestureExecute.mgResetRocker();
  },

  mgB_Stop : function() {
    BrowserStop();
  },

  mgB_UndoCloseTab : function() {
    try {       // Fx
      undoCloseTab();
    }
    catch (e) { // SM
      gBrowser.restoreTab(0);
    }
  },

  mgB_UpDir : function() { //from bookmarklets.com
    if (window._content.document.location.protocol != "about:") {
      var aUrl = window._content.document.location.href;
      aUrl = aUrl.substring(0, aUrl.substring(0, aUrl.length-1).lastIndexOf('/')+1);
      aUrl = mgCommon.makeURI(aUrl);

      if (aUrl.spec != (aUrl.scheme + ":///"))
        window._content.document.location.href = aUrl.spec;
    }
  },

  mgB_ViewPageInfo : function() {
    BrowserPageInfo();
  },

  mgB_ViewPageSource : function() {
    BrowserViewSourceOfDocument(content.document);
  },

  mgB_ZoomIn : function() {
    if (ZoomManager.prototype)     //SM
      ZoomManager.prototype.getInstance().enlarge();
    else if ("FullZoom" in window) //Fx
      FullZoom.enlarge();
    else if (ZoomManager.enlarge)  //Tb
      ZoomManager.enlarge();
  },

  mgB_ZoomOut : function() {
    if (ZoomManager.prototype)
      ZoomManager.prototype.getInstance().reduce();
    else if ("FullZoom" in window)
      FullZoom.reduce();
    else if (ZoomManager.reduce)
      ZoomManager.reduce();
  },

  mgB_ZoomIn_DoubleImage : function() {
    if (globalOnImage && mgGestureState.srcEvent.target.nodeName.toLowerCase() == "img")
      mgBuiltInFunctions.mgB_DoubleImageSize();
    else
      mgBuiltInFunctions.mgB_ZoomIn();
  },

  mgB_ZoomOut_HalveImage : function() {
    if (globalOnImage && mgGestureState.srcEvent.target.nodeName.toLowerCase() == "img")
      mgBuiltInFunctions.mgB_HalveImageSize();
    else
      mgBuiltInFunctions.mgB_ZoomOut();
  },

  mgB_ResetZoom : function() {
    var doc = mgGestureState.srcEvent.view.document;

    if (ZoomManager.prototype)
      ZoomManager.prototype.getInstance().reset();
    else if ("FullZoom" in window)
      FullZoom.reset();
    else if (ZoomManager.reset)
      ZoomManager.reset();

    if (doc.images && doc.images.length > 0) {
      for (var y = 0; y < doc.images.length; y++) {
        var img = doc.images[y];

        if (img.mgOriginalWidth &&
            !isNaN(img.mgOriginalWidth) &&
            !isNaN(img.mgOriginalHeight)) {
          img.style.width = img.mgOriginalWidth +"px";
          img.style.height = img.mgOriginalHeight +"px";
          img.mgImageRatio = img.mgOriginalWidth = img.mgOriginalHeight = false;
        }
      }
    }
  },

  /*** HELPER FUNCTIONS ***/

  mgAdvanceTab : function(dir) {
    mgBuiltInFunctions.mgClearSelection();
    gBrowser.mTabBox._tabs.advanceSelectedTab(dir, true);
  },

  mgGetReferrer : function(aLink) {
    try {
      var mgRefURL = aLink.ownerDocument.location.href;

      if (mgRefURL)
        return mgCommon.makeURI(mgRefURL, null, null);
    }
    catch (e) {}
    return null;
  },

  mgGetSelection : function() {
    return (mgGestureState.srcEvent.view != null) ? mgGestureState.srcEvent.view.getSelection() : "";
  },

  mgClearSelection : function() {
    try {
      if (mgGestureState.rockerCode.length >= 2 &&
          mgGestureState.rockerCode.indexOf(":0") == 0)
        mgBuiltInFunctions.mgGetSelection().removeAllRanges();
    }
    catch (e) {}
  },

  mgLinkInTab : function(url, aLink) {
    var tab = gBrowser.addTab(url, mgBuiltInFunctions.mgGetReferrer(aLink), null);
    if (!mgPrefs.root.getBoolPref("browser.tabs.loadInBackground")) {
      mgBuiltInFunctions.mgClearSelection();
      gBrowser.selectedTab = tab;
    }
  },

  mgLoadSideBar : function(aUrl, aPostData) {
    var mgSidebar = document.getElementById("sidebar");
    if (!mgSidebar.contentDocument ||
        !mgSidebar.contentDocument.getElementById('web-panels-browser')) {
      setTimeout(mgBuiltInFunctions.mgLoadSideBar, 100, aUrl, aPostData);
      return;
    }
    mgSidebar.contentDocument.getElementById('web-panels-browser')
             .loadURIWithFlags(aUrl, null, null, null, aPostData);
  },

  mgNewBrowserWindow : function() {
    window.open();
    return mgCommon.winMediator.getMostRecentWindow("navigator:browser");
  },

  mgOpenTab : function() {
    if (globalOnLink && globalOnLink.length > 0)
      mgBuiltInFunctions.mgLinkInTab(globalOnLink[0].href, globalOnLink[0]);
    else {
      var sel = mgBuiltInFunctions.mgGetSelection().toString();
      if (sel.match(/^(http)|(ftp):/))
        mgBuiltInFunctions.mgLinkInTab(sel, null);
      else {
        mgBuiltInFunctions.mgClearSelection();
        BrowserOpenTab();
      }
    }
  },

  mgSetImageSize : function(aSize) {
    if (!globalOnImage)
      return;

    var img = globalOnImage;

    if (!img.mgImageRatio) {
      img.mgImageRatio = img.width / img.height;
      img.mgOriginalWidth = img.width;
      img.mgOriginalHeight = img.height;
    }
    if (!isNaN(img.mgImageRatio)) {
      var w = parseFloat(img.style.width);
      if (isNaN(w))
        w = img.width;

      img.style.width = (w * aSize) + "px";
      w = parseFloat(img.style.width);
      img.style.height = (w / img.mgImageRatio) + "px";
    }
  },

  /*** GENERIC FUNCTIONS ***/

  mgW_CloseWin : function() {
    if (mgWindowType == "unknownWindow")
      window.close();
    else if ("BrowserTryToCloseWindow" in window)
      window.setTimeout("BrowserTryToCloseWindow()", 10);
    else
      window.setTimeout("window.close()", 10);
  },

  mgW_Copy : function() {
    goDoCommand('cmd_copy');
  },

  mgW_Cut : function() {
    goDoCommand('cmd_cut');
  },

  mgW_MinWin : function() {
    if (window.minimize != 'undefined') {
      window.minimize();
      mgGestureExecute.mgResetRocker(true);
    }
  },

  mgW_Paste : function() {
    goDoCommand('cmd_paste');
  },

  mgW_Restart : function() {
    var nsIAppStartup = Components.interfaces.nsIAppStartup;
    var appStartup = Components.classes["@mozilla.org/toolkit/app-startup;1"]
                     .getService(nsIAppStartup);

    try {
      appStartup.quit(nsIAppStartup.eRestart | nsIAppStartup.eAttemptQuit);
    }
    catch (err) {
      appStartup.quit(nsIAppStartup.eRestart | nsIAppStartup.eForceQuit);
    }
  },

  mgW_RestMaxWin : function() {
    if (window.maximize != 'undefined') {
      if (window.windowState == STATE_MAXIMIZED)
        window.restore();
      else window.maximize();
    }
  },

  mgW_ScrollDown : function() {
    mgBuiltInFunctions.mgWScroll("down");
  },

  mgW_ScrollUp : function() {
    mgBuiltInFunctions.mgWScroll("up");
  },

  mgW_ScrollLeft : function() {
    mgBuiltInFunctions.mgWScroll("left");
  },

  mgW_ScrollRight : function() {
    mgBuiltInFunctions.mgWScroll("right");
  },

  mgWScroll : function(direct) {
    var amount = mgPrefs.prefs.getIntPref("misc.funcPref.mgWScroll.scrollBy");
    amount = (direct == "up" || direct == "left") ? -amount : amount;
    var horizontal = (direct == "left" || direct == "right") ? true : false;
    mgGestureState.srcEvent.view.scrollBy(horizontal ? amount : 0, horizontal ? 0 : amount);
  },

  /*** MESSENGER FUNCTIONS ***/

  mgM_DeleteMessage : function() {
    goDoCommand('cmd_delete');
  },

  mgM_ForwardMessage : function() {
    goDoCommand('cmd_forward');
  },

  mgM_Home : function() {
    loadStartPage();
  },

  mgM_NextMessage : function() {
    goDoCommand('cmd_nextMsg');
  },

  mgM_NextUnreadMessage : function() {
    goDoCommand('cmd_nextUnreadMsg');
  },

  mgM_NewMessage : function() {
    MsgNewMessage();
  },

  mgM_OpenLinks : function() {
    if (globalOnLink && globalOnLink.length > 0) {
      for (var x=0; x<globalOnLink.length; x++)
        mgCommon.showWebPage(globalOnLink[x].href);
    }
  },

  mgM_PrevMessage : function() {
    goDoCommand('cmd_previousMsg');
  },

  mgM_PrevUnreadMessage : function() {
    goDoCommand('cmd_previousUnreadMsg');
  },

  mgM_Reload : function() {
    goDoCommand('cmd_reload');
  },

  mgM_ReplyMessage : function() {
    goDoCommand('cmd_reply');
  },

  mgM_ViewSource : function() {
    goDoCommand('cmd_viewPageSource');
  }
}