/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing;

import com.sun.java.swing.Icon;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URL;

public class ImageIcon
implements Icon,
Serializable {
    transient Image image;
    transient int loadStatus;
    ImageObserver imageObserver;
    String description;
    protected static final Component component = new 1();
    protected static final MediaTracker tracker = new MediaTracker(component);
    int width = -1;
    int height = -1;

    public ImageIcon(String string, String string2) {
        this.image = Toolkit.getDefaultToolkit().getImage(string);
        this.description = string2;
        this.loadImage(this.image);
    }

    public ImageIcon(String string) {
        this(string, string);
    }

    public ImageIcon(URL uRL, String string) {
        this.image = Toolkit.getDefaultToolkit().getImage(uRL);
        this.description = string;
        this.loadImage(this.image);
    }

    public ImageIcon(URL uRL) {
        this(uRL, uRL.toExternalForm());
    }

    public ImageIcon(Image image, String string) {
        this(image);
        this.description = string;
    }

    public ImageIcon(Image image) {
        this.image = image;
        Object object = image.getProperty("comment", this.imageObserver);
        if (object instanceof String) {
            this.description = (String)object;
        }
        this.loadImage(image);
    }

    public ImageIcon(byte[] byArray, String string) {
        this.image = Toolkit.getDefaultToolkit().createImage(byArray);
        if (this.image == null) {
            return;
        }
        this.description = string;
        this.loadImage(this.image);
    }

    public ImageIcon(byte[] byArray) {
        this.image = Toolkit.getDefaultToolkit().createImage(byArray);
        if (this.image == null) {
            return;
        }
        Object object = this.image.getProperty("comment", this.imageObserver);
        if (object instanceof String) {
            this.description = (String)object;
        }
        this.loadImage(this.image);
    }

    public ImageIcon() {
    }

    protected void loadImage(Image image) {
        MediaTracker mediaTracker = tracker;
        synchronized (mediaTracker) {
            tracker.addImage(image, 0);
            try {
                tracker.waitForID(0, 5000L);
            }
            catch (InterruptedException interruptedException) {
                System.out.println("INTERRUPTED while loading Image");
            }
            this.loadStatus = tracker.statusID(0, false);
            tracker.removeImage(image, 0);
            this.width = image.getWidth(this.imageObserver);
            this.height = image.getHeight(this.imageObserver);
            return;
        }
    }

    public int getImageLoadStatus() {
        return this.loadStatus;
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
        this.loadImage(image);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public synchronized void paintIcon(Component component, Graphics graphics, int n, int n2) {
        if (this.imageObserver == null) {
            graphics.drawImage(this.image, n, n2, component);
            return;
        }
        graphics.drawImage(this.image, n, n2, this.imageObserver);
    }

    public int getIconWidth() {
        return this.width;
    }

    public int getIconHeight() {
        return this.height;
    }

    public void setImageObserver(ImageObserver imageObserver) {
        this.imageObserver = imageObserver;
    }

    public ImageObserver getImageObserver() {
        return this.imageObserver;
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        int n2 = objectInputStream.readInt();
        int[] nArray = (int[])objectInputStream.readObject();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        ColorModel colorModel = ColorModel.getRGBdefault();
        this.image = toolkit.createImage(new MemoryImageSource(n, n2, colorModel, nArray, 0, n));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        int n = this.getIconWidth();
        int n2 = this.getIconHeight();
        int[] nArray = new int[n * n2];
        try {
            PixelGrabber pixelGrabber = new PixelGrabber(this.image, 0, 0, n, n2, nArray, 0, n);
            pixelGrabber.grabPixels();
            if ((pixelGrabber.getStatus() & 0x80) != 0) {
                throw new IOException("failed to load image contents");
            }
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("image load interrupted");
        }
        objectOutputStream.writeInt(n);
        objectOutputStream.writeInt(n2);
        objectOutputStream.writeObject(nArray);
    }

    private final class 1
    extends Component {
        /* synthetic */ 1() {
        }
    }
}

